/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class TwoFactorAuthMethodEditDialog
extends Dialog {
    private TwoFactorAuthenticationMethod method;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textConfiguraiton;
    private Combo comboDriverName;
    private boolean isNameChanged;
    private String newName;

    public TwoFactorAuthMethodEditDialog(Shell parentShell, TwoFactorAuthenticationMethod method) {
        super(parentShell);
        this.method = method;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel("Description");
        this.textDescription.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboDriverName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Driver name", (Object)gd);
        this.textConfiguraiton = new LabeledText(dialogArea, 0, 2050);
        this.textConfiguraiton.setLabel("Driver Configuration");
        this.textConfiguraiton.getTextControl().setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 900;
        this.textConfiguraiton.setLayoutData((Object)gd);
        if (this.method != null) {
            this.textName.setText(this.method.getName());
            this.textDescription.setText(this.method.getDescription());
            this.textConfiguraiton.setText(this.method.getConfiguration());
        }
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get two-factor authentication method driver names", null, "org.netxms.ui.eclipse.serverconfig"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List drivers = session.get2FADrivers();
                Collections.sort(drivers, String.CASE_INSENSITIVE_ORDER);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TwoFactorAuthMethodEditDialog.this.updateDriverList(drivers);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of two-factor authentication method drivers";
            }
        }.start();
        return dialogArea;
    }

    private void updateDriverList(List<String> drivers) {
        this.comboDriverName.removeAll();
        int i = 0;
        while (i < drivers.size()) {
            this.comboDriverName.add(drivers.get(i));
            if (this.method != null && drivers.get(i).equals(this.method.getDriver())) {
                this.comboDriverName.select(i);
            }
            ++i;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.method != null ? "Edit Method" : "Create Method");
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Method name should not be empty");
            return;
        }
        if (this.comboDriverName.getSelectionIndex() == -1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Driver should be selected");
            return;
        }
        if (this.method == null) {
            this.method = new TwoFactorAuthenticationMethod(this.textName.getText(), this.textDescription.getText(), this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()), this.textConfiguraiton.getText());
        } else {
            if (!this.method.getName().equals(this.textName.getText())) {
                this.isNameChanged = true;
                this.newName = this.textName.getText();
            }
            this.method.setDescription(this.textDescription.getText());
            this.method.setDriver(this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()));
            this.method.setConfiguration(this.textConfiguraiton.getText());
        }
        super.okPressed();
    }

    public TwoFactorAuthenticationMethod getMethod() {
        return this.method;
    }

    public boolean isNameChanged() {
        return this.isNameChanged;
    }

    public String getNewName() {
        return this.newName;
    }
}

