/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.objectbrowser.widgets.internal.ObjectFilter;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ChildObjectListDialog
extends Dialog {
    private long parentObject;
    private Set<Integer> classFilter;
    private ObjectFilter filter;
    private Text filterText;
    private TableViewer objectList;
    private List<AbstractObject> selectedObjects;

    public static Set<Integer> createClassFilter(int[] classes) {
        HashSet<Integer> filter = new HashSet<Integer>(classes.length);
        int i = 0;
        while (i < classes.length) {
            filter.add(classes[i]);
            ++i;
        }
        return filter;
    }

    public static Set<Integer> createClassFilter(int c) {
        HashSet<Integer> filter = new HashSet<Integer>(1);
        filter.add(c);
        return filter;
    }

    public ChildObjectListDialog(Shell parentShell, long parentObject, Set<Integer> classFilter) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.parentObject = parentObject;
        this.classFilter = classFilter;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ChildObjectListDialog_SelectSubordinate);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("ChildObjectListDialog.cx"), settings.getInt("ChildObjectListDialog.cy"));
        }
        catch (NumberFormatException e) {
            newShell.setSize(300, 350);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        AbstractObject object = ConsoleSharedData.getSession().findObjectById(this.parentObject);
        AbstractObject[] sourceObjects = object != null ? object.getChildrenAsArray() : new AbstractObject[]{};
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Composite filterArea = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        filterArea.setLayout((Layout)layout);
        filterArea.setLayoutData((Object)new GridData(768));
        Label filterLabel = new Label(filterArea, 0);
        Messages.get();
        filterLabel.setText(Messages.ChildObjectListDialog_Filter);
        this.filterText = new Text(filterArea, 2048);
        this.filterText.setLayoutData((Object)new GridData(768));
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChildObjectListDialog.this.filter.setFilterString(ChildObjectListDialog.this.filterText.getText());
                ChildObjectListDialog.this.objectList.refresh(false);
                AbstractObject obj = ChildObjectListDialog.this.filter.getLastMatch();
                if (obj != null) {
                    ChildObjectListDialog.this.objectList.setSelection((ISelection)new StructuredSelection((Object)obj), true);
                    ChildObjectListDialog.this.objectList.reveal((Object)obj);
                }
            }
        });
        this.objectList = new TableViewer(dialogArea, 67586);
        TableColumn tc = new TableColumn(this.objectList.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.ChildObjectListDialog_Name);
        tc.setWidth(280);
        this.objectList.getTable().setHeaderVisible(false);
        this.objectList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.objectList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.objectList.setComparator(new ViewerComparator());
        this.filter = new ObjectFilter(sourceObjects, this.classFilter);
        this.objectList.addFilter((ViewerFilter)this.filter);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.objectList.getControl().setLayoutData((Object)gd);
        this.objectList.getTable().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Table table = ChildObjectListDialog.this.objectList.getTable();
                int w = table.getSize().x - table.getBorderWidth() * 2;
                ScrollBar sc = table.getVerticalBar();
                if (sc != null && sc.isVisible()) {
                    w -= sc.getSize().x;
                }
                table.getColumn(0).setWidth(w);
            }
        });
        if (object != null) {
            this.objectList.setInput((Object)sourceObjects);
        }
        this.filterText.setFocus();
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.objectList.getSelection();
        this.selectedObjects = new ArrayList<AbstractObject>(selection.size());
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            this.selectedObjects.add((AbstractObject)it.next());
        }
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("ChildObjectListDialog.cx", size.x);
        settings.put("ChildObjectListDialog.cy", size.y);
    }

    public List<AbstractObject> getSelectedObjects() {
        return this.selectedObjects;
    }
}

