/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.CertificateMappingMethod;
import org.netxms.client.constants.UserAuthenticationMethod;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.client.users.User;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.dialogs.TwoFactorAuthMethodEditDialog;

public class Authentication
extends PropertyPage {
    private NXCSession session = ConsoleSharedData.getSession();
    private User object;
    private List<MethodBinding> twoFactorAuthMethodBindings;
    private Button checkDisabled;
    private Button checkChangePassword;
    private Button checkFixedPassword;
    private Button checkCloseSessions;
    private Combo comboAuthMethod;
    private Combo comboMappingMethod;
    private Text textMappingData;
    private TableViewer twoFactorAuthMethodList;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (User)this.getElement().getAdapter(User.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Group groupFlags = new Group(dialogArea, 0);
        Messages.get();
        groupFlags.setText(Messages.Authentication_AccountOptions);
        layout = new GridLayout();
        groupFlags.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupFlags.setLayoutData((Object)gd);
        this.checkDisabled = new Button((Composite)groupFlags, 32);
        Messages.get();
        this.checkDisabled.setText(Messages.Authentication_AccountDisabled);
        this.checkDisabled.setSelection(this.object.isDisabled());
        this.checkChangePassword = new Button((Composite)groupFlags, 32);
        Messages.get();
        this.checkChangePassword.setText(Messages.Authentication_MustChangePassword);
        this.checkChangePassword.setSelection(this.object.isPasswordChangeNeeded());
        this.checkFixedPassword = new Button((Composite)groupFlags, 32);
        Messages.get();
        this.checkFixedPassword.setText(Messages.Authentication_CannotChangePassword);
        this.checkFixedPassword.setSelection(this.object.isPasswordChangeForbidden());
        this.checkCloseSessions = new Button((Composite)groupFlags, 32);
        Messages.get();
        this.checkCloseSessions.setText(Messages.Authentication_CloseOtherSessions);
        this.checkCloseSessions.setSelection((this.object.getFlags() & 0x200) != 0);
        Group groupMethod = new Group(dialogArea, 0);
        Messages.get();
        groupMethod.setText(Messages.Authentication_AuthMethod_Group);
        layout = new GridLayout();
        layout.numColumns = 2;
        groupMethod.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        groupMethod.setLayoutData((Object)gd);
        Label label = new Label((Composite)groupMethod, 0);
        Messages.get();
        label.setText(Messages.Authentication_AuthMethod_Label);
        this.comboAuthMethod = new Combo((Composite)groupMethod, 12);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_Local);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_RADIUS);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_Certificate);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_CertificateOrLocal);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_CertificateOrRADIUS);
        Messages.get();
        this.comboAuthMethod.add(Messages.Authentication_LDAP);
        this.comboAuthMethod.select(this.object.getAuthMethod().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboAuthMethod.setLayoutData((Object)gd);
        label = new Label((Composite)groupMethod, 0);
        Messages.get();
        label.setText(Messages.Authentication_CertMapping);
        this.comboMappingMethod = new Combo((Composite)groupMethod, 12);
        Messages.get();
        this.comboMappingMethod.add(Messages.Authentication_Subject);
        Messages.get();
        this.comboMappingMethod.add(Messages.Authentication_PublicKey);
        Messages.get();
        this.comboMappingMethod.add(Messages.Authentication_CommonName);
        this.comboMappingMethod.add("Template ID");
        this.comboMappingMethod.select(this.object.getCertMappingMethod().getValue());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboMappingMethod.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        gd.widthHint = 300;
        Messages.get();
        this.textMappingData = WidgetHelper.createLabeledText((Composite)groupMethod, (int)2052, (int)-1, (String)Messages.Authentication_MappingData, (String)this.object.getCertMappingData(), (Object)gd);
        Group twoFactorAuth = new Group(dialogArea, 0);
        twoFactorAuth.setText("Two-factor authentication methods");
        layout = new GridLayout();
        layout.numColumns = 2;
        twoFactorAuth.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        twoFactorAuth.setLayoutData((Object)gd);
        this.twoFactorAuthMethodList = new TableViewer((Composite)twoFactorAuth, 67586);
        this.twoFactorAuthMethodList.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.twoFactorAuthMethodList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.twoFactorAuthMethodList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MethodBinding)element).name;
            }
        });
        this.twoFactorAuthMethodList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((MethodBinding)e1).name.compareToIgnoreCase(((MethodBinding)e2).name);
            }
        });
        Composite buttons = new Composite((Composite)twoFactorAuth, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        gd = new GridData();
        gd.verticalAlignment = 128;
        buttons.setLayoutData((Object)gd);
        Button addButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        addButton.setLayoutData((Object)gd);
        Messages.get();
        addButton.setText(Messages.Members_Add);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Authentication.this.addMethod();
            }
        });
        final Button editButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        editButton.setLayoutData((Object)gd);
        editButton.setText("&Edit...");
        editButton.setEnabled(false);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Authentication.this.editMethod();
            }
        });
        final Button deleteButton = new Button(buttons, 8);
        gd = new GridData();
        gd.widthHint = 90;
        deleteButton.setLayoutData((Object)gd);
        Messages.get();
        deleteButton.setText(Messages.Members_Delete);
        deleteButton.setEnabled(false);
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = Authentication.this.twoFactorAuthMethodList.getStructuredSelection();
                for (Object o : selection.toList()) {
                    Authentication.this.twoFactorAuthMethodBindings.remove(o);
                }
                Authentication.this.twoFactorAuthMethodList.refresh();
            }
        });
        this.twoFactorAuthMethodList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = Authentication.this.twoFactorAuthMethodList.getStructuredSelection();
                editButton.setEnabled(selection.size() == 1);
                deleteButton.setEnabled(!selection.isEmpty());
            }
        });
        this.twoFactorAuthMethodList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                Authentication.this.editMethod();
            }
        });
        this.twoFactorAuthMethodBindings = new ArrayList<MethodBinding>(this.object.getTwoFactorAuthMethodBindings().size());
        for (Map.Entry e : this.object.getTwoFactorAuthMethodBindings().entrySet()) {
            this.twoFactorAuthMethodBindings.add(new MethodBinding((String)e.getKey(), (Map)e.getValue()));
        }
        this.twoFactorAuthMethodList.setInput(this.twoFactorAuthMethodBindings);
        return dialogArea;
    }

    private void addMethod() {
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getShell(), null, null);
        if (dlg.open() != 0) {
            return;
        }
        for (MethodBinding b : this.twoFactorAuthMethodBindings) {
            if (!b.name.equals(dlg.getName())) continue;
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)String.format("Two-factor authentication method %s already configured", b.name));
            return;
        }
        this.twoFactorAuthMethodBindings.add(new MethodBinding(dlg.getName(), dlg.getConfiguration()));
        this.twoFactorAuthMethodList.refresh();
    }

    private void editMethod() {
        IStructuredSelection selection = this.twoFactorAuthMethodList.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        MethodBinding b = (MethodBinding)selection.getFirstElement();
        TwoFactorAuthMethodEditDialog dlg = new TwoFactorAuthMethodEditDialog(this.getShell(), b.name, b.configuration);
        if (dlg.open() != 0) {
            return;
        }
        b.configuration = dlg.getConfiguration();
        this.twoFactorAuthMethodList.refresh();
    }

    protected void applyChanges(final boolean isApply) {
        int flags = 0;
        if (this.checkDisabled.getSelection()) {
            flags |= 4;
        }
        if (this.checkChangePassword.getSelection()) {
            flags |= 8;
        }
        if (this.checkFixedPassword.getSelection()) {
            flags |= 0x10;
        }
        if (this.checkCloseSessions.getSelection()) {
            flags |= 0x200;
        }
        this.object.setFlags(flags |= this.object.getFlags() & 0x80);
        this.object.setAuthMethod(UserAuthenticationMethod.getByValue((int)this.comboAuthMethod.getSelectionIndex()));
        this.object.setCertMappingMethod(CertificateMappingMethod.getByValue((int)this.comboMappingMethod.getSelectionIndex()));
        this.object.setCertMappingData(this.textMappingData.getText());
        HashMap<String, Map<String, String>> bindings = new HashMap<String, Map<String, String>>(this.twoFactorAuthMethodBindings.size());
        for (MethodBinding b : this.twoFactorAuthMethodBindings) {
            bindings.put(b.name, b.configuration);
        }
        this.object.setTwoFactorAuthMethodBindings(bindings);
        if (isApply) {
            this.setValid(false);
        }
        Messages.get();
        new ConsoleJob(Messages.Authentication_JobTitle, null, "org.netxms.ui.eclipse.usermanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Authentication.this.session.modifyUserDBObject((AbstractUserObject)Authentication.this.object, 32968);
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Authentication.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Authentication_JobError;
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    private static class MethodBinding {
        String name;
        Map<String, String> configuration;

        public MethodBinding(String name, Map<String, String> configuration) {
            this.name = name;
            this.configuration = new HashMap<String, String>(configuration);
        }
    }
}

