/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.api;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.datacollection.DciSummaryTableDescriptor;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.SourceProvider;

public class SummaryTablesCache {
    private static Map<Integer, DciSummaryTableDescriptor> tables = new HashMap<Integer, DciSummaryTableDescriptor>();
    private static NXCSession session = null;

    public static void init(NXCSession session) {
        SummaryTablesCache.session = session;
        SummaryTablesCache.reload();
        session.addListener(new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1021: {
                        SummaryTablesCache.onTableChange((int)n.getSubCode());
                        break;
                    }
                    case 1022: {
                        SummaryTablesCache.onTableDelete((int)n.getSubCode());
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reload() {
        try {
            List list = session.listDciSummaryTables();
            Map<Integer, DciSummaryTableDescriptor> map = tables;
            synchronized (map) {
                tables.clear();
                for (DciSummaryTableDescriptor d : list) {
                    tables.put(d.getId(), d);
                }
            }
            SourceProvider.getInstance().update();
        }
        catch (Exception e) {
            Activator.logError("Exception in SummaryTablesCache.reload()", e);
        }
    }

    private static void onTableChange(int tableId) {
        new Thread(){

            @Override
            public void run() {
                SummaryTablesCache.reload();
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void onTableDelete(int tableId) {
        Map<Integer, DciSummaryTableDescriptor> map = tables;
        synchronized (map) {
            tables.remove(tableId);
        }
        SourceProvider.getInstance().update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DciSummaryTableDescriptor[] getTables() {
        Map<Integer, DciSummaryTableDescriptor> map = tables;
        synchronized (map) {
            return tables.values().toArray(new DciSummaryTableDescriptor[tables.values().size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmpty(boolean menuOnly) {
        Map<Integer, DciSummaryTableDescriptor> map = tables;
        synchronized (map) {
            DciSummaryTableDescriptor d;
            if (!menuOnly) {
                return tables.isEmpty();
            }
            Iterator<DciSummaryTableDescriptor> iterator = tables.values().iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((d = iterator.next()).getMenuPath().isEmpty());
            return false;
        }
    }
}

