/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Script;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.Messages;
import org.netxms.ui.eclipse.nxsl.dialogs.CreateScriptDialog;
import org.netxms.ui.eclipse.nxsl.dialogs.SaveScriptDialog;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.TextConsole;

public class ScriptExecutor
extends ViewPart
implements ISaveablePart2,
TextOutputListener {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptExecutor";
    private NXCSession session;
    private boolean modified = false;
    private boolean saveOnClose = false;
    private boolean doSaveAs = false;
    private long objectId;
    private Label scriptName;
    private Combo scriptCombo;
    private ScriptEditor scriptEditor;
    private Text parametersField;
    private TextConsole output;
    private IOConsoleOutputStream consoleOutputStream;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionClear;
    private Action actionClearOutput;
    private Action actionReload;
    private Action actionExecute;
    private List<Script> library;
    private int previousSelection = -1;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.objectId = Long.parseLong(site.getSecondaryId());
        Messages.get();
        this.setPartName(String.format(Messages.ScriptExecutor_PartName, this.session.getObjectName(this.objectId)));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        Composite formContainer = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        formContainer.setLayout((Layout)layout);
        this.scriptName = new Label(formContainer, 16384);
        this.scriptName.setFont(JFaceResources.getBannerFont());
        this.scriptName.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        this.scriptName.setText(Messages.ScriptExecutor_Noname);
        Messages.get();
        this.scriptCombo = WidgetHelper.createLabeledCombo((Composite)formContainer, (int)8, (String)Messages.ScriptExecutor_LibScript, (Object)"WidgetHelper::default_layout_data");
        this.updateScriptList(null);
        this.scriptCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(true)) {
                    return;
                }
                ScriptExecutor.this.getScriptContent();
                ScriptExecutor.this.previousSelection = ScriptExecutor.this.scriptCombo.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        SashForm splitter = new SashForm(formContainer, 512);
        splitter.setSashWidth(3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        splitter.setLayoutData((Object)gridData);
        Composite container = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 4;
        container.setLayout((Layout)layout);
        Label label = new Label(container, 16384);
        label.setText("Parameters (comma-separated list)");
        this.parametersField = new Text(container, 2052);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.parametersField.setLayoutData((Object)gridData);
        label = new Label(container, 16384);
        Messages.get();
        label.setText(Messages.ScriptExecutor_Source);
        this.scriptEditor = new ScriptEditor(container, 2048, 768, true);
        this.scriptEditor.setText("");
        this.scriptEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptExecutor.this.onTextModify();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.scriptEditor.setLayoutData(gridData);
        container = new Composite((Composite)splitter, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        container.setLayout((Layout)layout);
        label = new Label(container, 16384);
        Messages.get();
        label.setText(Messages.ScriptExecutor_Output);
        this.output = new TextConsole(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        this.output.setLayoutData((Object)gridData);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.actionSave.setEnabled(false);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.nxsl.context.ScriptExecutor");
        }
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
            if (this.scriptCombo.getSelectionIndex() != -1) {
                this.actionSave.setEnabled(true);
            }
        }
    }

    public void setFocus() {
        this.scriptEditor.setFocus();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionSave = new Action(Messages.ScriptExecutor_Save, SharedIcons.SAVE){

            public void run() {
                ScriptExecutor.this.intermediateSave(false);
            }
        };
        this.actionSave.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.save");
        handlerService.activateHandler(this.actionSave.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSave));
        Messages.get();
        this.actionSaveAs = new Action(Messages.ScriptExecutor_SaveAs, SharedIcons.SAVE_AS){

            public void run() {
                ScriptExecutor.this.createNewScript(false);
            }
        };
        this.actionSaveAs.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.save_as");
        handlerService.activateHandler(this.actionSaveAs.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSaveAs));
        Messages.get();
        this.actionClear = new Action(Messages.ScriptExecutor_Clear, SharedIcons.CLEAR){

            public void run() {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(false)) {
                    return;
                }
                ScriptExecutor.this.scriptCombo.deselectAll();
                ScriptExecutor.this.scriptCombo.clearSelection();
                ScriptExecutor.this.scriptEditor.setText("");
                ScriptExecutor.this.output.clear();
                Label label = ScriptExecutor.this.scriptName;
                Messages.get();
                label.setText(Messages.ScriptExecutor_Noname);
            }
        };
        Messages.get();
        this.actionClearOutput = new Action(Messages.ScriptExecutor_ClearOutput, SharedIcons.CLEAR_LOG){

            public void run() {
                ScriptExecutor.this.output.clear();
            }
        };
        this.actionClearOutput.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.clear_output");
        handlerService.activateHandler(this.actionClearOutput.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClearOutput));
        this.actionReload = new RefreshAction((IViewPart)this){

            public void run() {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(false)) {
                    return;
                }
                ScriptExecutor.this.updateScriptList(null);
                ScriptExecutor.this.getScriptContent();
                ScriptExecutor.this.output.clear();
            }
        };
        Messages.get();
        this.actionReload.setText(Messages.ScriptExecutor_Reload);
        Messages.get();
        this.actionExecute = new Action(Messages.ScriptExecutor_Execute, SharedIcons.EXECUTE){

            public void run() {
                ScriptExecutor.this.executeScript();
            }
        };
        this.actionExecute.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.execute_script");
        handlerService.activateHandler(this.actionExecute.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionExecute));
    }

    private boolean saveIfRequired(boolean onSelectionChange) {
        SaveScriptDialog dlg = new SaveScriptDialog(this.getSite().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        switch (rc) {
            case 100: {
                this.intermediateSave(onSelectionChange);
                break;
            }
            case 101: {
                this.createNewScript(onSelectionChange);
                break;
            }
            case 102: {
                this.getScriptContent();
                this.clearDirtyFlags();
                break;
            }
            default: {
                this.scriptCombo.select(this.previousSelection);
            }
        }
        return rc == 1;
    }

    private boolean createNewScript(final boolean saveOnSelectionChange) {
        final CreateScriptDialog dlg = new CreateScriptDialog(this.getSite().getShell(), null);
        if (dlg.open() != 0) {
            return false;
        }
        final String scriptSource = this.scriptEditor.getText();
        Messages.get();
        new ConsoleJob(Messages.ScriptExecutor_JobName_Create, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.session.modifyScript(0L, dlg.getName(), scriptSource);
                if (!ScriptExecutor.this.saveOnClose) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Runnable run = new Runnable(){

                                @Override
                                public void run() {
                                    ((this).this).ScriptExecutor.this.scriptCombo.select(((this).this).ScriptExecutor.this.scriptCombo.indexOf(dlg.getName()));
                                }
                            };
                            ScriptExecutor.this.updateScriptList(saveOnSelectionChange ? null : run);
                            ScriptExecutor.this.clearDirtyFlags();
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptExecutor_JobError_Create;
            }
        }.start();
        return true;
    }

    protected void getScriptContent() {
        final int index = this.scriptCombo.getSelectionIndex();
        if (index == -1) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.ScriptExecutor_JobName_Update, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Script script = ScriptExecutor.this.session.getScript(ScriptExecutor.this.library.get(index).getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptExecutor.this.scriptEditor.setText(script.getSource());
                        ScriptExecutor.this.clearDirtyFlags();
                        (this).ScriptExecutor.this.scriptName.setText(script.getName());
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptExecutor_JobError_Update;
            }
        }.start();
    }

    protected void executeScript() {
        final String script = this.scriptEditor.getText();
        final String parameters = this.parametersField.getText();
        this.consoleOutputStream = this.output.newOutputStream();
        this.actionExecute.setEnabled(false);
        Messages.get();
        new ConsoleJob(Messages.ScriptExecutor_JobName_Execute, null, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.session.executeScript(ScriptExecutor.this.objectId, script, parameters, (TextOutputListener)ScriptExecutor.this);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptExecutor_JobError_Execute;
            }

            protected void jobFinalize() {
                try {
                    ScriptExecutor.this.consoleOutputStream.close();
                    ScriptExecutor.this.consoleOutputStream = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptExecutor.this.actionExecute.setEnabled(true);
                    }
                });
            }
        }.start();
    }

    private void updateScriptList(final Runnable postProcessor) {
        final String selection = this.scriptCombo.getSelectionIndex() != -1 ? this.scriptCombo.getItem(this.scriptCombo.getSelectionIndex()) : null;
        Messages.get();
        new ConsoleJob(Messages.ScriptExecutor_JobName_ReadList, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.library = ScriptExecutor.this.session.getScriptLibrary();
                Collections.sort(ScriptExecutor.this.library, new Comparator<Script>(){

                    @Override
                    public int compare(Script lhs, Script rhs) {
                        return lhs.getName().compareTo(rhs.getName());
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).ScriptExecutor.this.scriptCombo.removeAll();
                        for (Script s : (this).ScriptExecutor.this.library) {
                            (this).ScriptExecutor.this.scriptCombo.add(s.getName());
                        }
                        if (postProcessor != null) {
                            postProcessor.run();
                        } else if (selection != null) {
                            (this).ScriptExecutor.this.scriptCombo.select((this).ScriptExecutor.this.scriptCombo.indexOf(selection));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptExecutor_JobError_ReadList;
            }
        }.start();
    }

    public void intermediateSave(boolean saveOnSelectionChange) {
        final Script s = this.library.get(saveOnSelectionChange ? this.previousSelection : this.scriptCombo.getSelectionIndex());
        final String scriptSource = this.scriptEditor.getText();
        Messages.get();
        new ConsoleJob(Messages.ScriptExecutor_JobName_Update, (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.session.modifyScript(s.getId(), s.getName(), scriptSource);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.clearDirtyFlags();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ScriptExecutor_JobError_Update;
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void clearDirtyFlags() {
        this.modified = false;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(false);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionReload);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionReload);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.saveOnClose && (!this.modified || this.doSaveAs)) {
            this.clearDirtyFlags();
            return;
        }
        try {
            Script s = this.library.get(this.scriptCombo.getSelectionIndex());
            this.session.modifyScript(s.getId(), s.getName(), this.scriptEditor.getText());
        }
        catch (Exception e) {
            Shell shell = this.getViewSite().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ScriptExecutor_Error, (String)String.format(Messages.ScriptExecutor_SaveError, e.getLocalizedMessage()));
        }
        this.clearDirtyFlags();
    }

    public void doSaveAs() {
        this.createNewScript(false);
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SaveScriptDialog dlg = new SaveScriptDialog(this.getSite().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        if (rc == 1) {
            return 2;
        }
        this.saveOnClose = true;
        if (rc == 101 && !this.createNewScript(false)) {
            return 2;
        }
        this.modified = rc != 102;
        this.doSaveAs = rc == 101;
        return 0;
    }

    public void messageReceived(String text) {
        if (this.consoleOutputStream != null) {
            try {
                this.consoleOutputStream.write(text);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void setStreamId(long streamId) {
    }

    public void onError() {
    }
}

