/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.ui.eclipse.dashboard.widgets.DCISummaryTableColumnSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DCISummaryTableSortColumnSelectionDialog
extends Dialog {
    private DCISummaryTableColumnSelector columnSelector;
    private Button checkDescending;
    private DciSummaryTable sourceSummaryTable;
    private int summaryTableId;
    private String columnName = "";
    private boolean descending;

    public DCISummaryTableSortColumnSelectionDialog(Shell parentShell, String columnName, boolean descending, int summaryTableId) {
        super(parentShell);
        this.columnName = columnName;
        this.descending = descending;
        this.summaryTableId = summaryTableId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit Sorting Column");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get summary table configuration by id", null, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DCISummaryTableSortColumnSelectionDialog.this.sourceSummaryTable = session.getDciSummaryTable(DCISummaryTableSortColumnSelectionDialog.this.summaryTableId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DCISummaryTableSortColumnSelectionDialog.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Unable to get summary table configuration";
            }
        }.start();
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.columnSelector = new DCISummaryTableColumnSelector(dialogArea, 0, 8, this.columnName, null, this.sourceSummaryTable);
        this.columnSelector.setLabel("Column");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        this.columnSelector.setLayoutData(gd);
        this.checkDescending = new Button(dialogArea, 32);
        this.checkDescending.setText("Descending order");
        this.checkDescending.setSelection(this.descending);
        return dialogArea;
    }

    private void refresh() {
        this.columnSelector.setSummaryTbale(this.sourceSummaryTable);
    }

    protected void okPressed() {
        this.columnName = String.valueOf(this.checkDescending.getSelection() ? ">" : "<") + this.columnSelector.getColumnName();
        super.okPressed();
    }

    public String getColumnName() {
        return this.columnName;
    }
}

