/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.netxms.base.NXCPMessage;

public class ObjectUrl {
    private int id;
    private URL url;
    private String description;

    public ObjectUrl(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt32(baseId);
        try {
            this.url = new URL(msg.getFieldAsString(baseId + 1L));
        }
        catch (MalformedURLException e) {
            this.url = null;
        }
        this.description = msg.getFieldAsString(baseId + 2L);
    }

    public ObjectUrl(int id, URL url, String description) {
        this.id = id;
        this.url = url;
        this.description = description;
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, this.id);
        msg.setField(baseId + 1L, this.url != null ? this.url.toExternalForm() : "");
        msg.setField(baseId + 2L, this.description);
    }

    public int getId() {
        return this.id;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getDescription() {
        return this.description;
    }
}

