/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BusinessServiceCheckType {
    NONE(0),
    SCRIPT(1),
    DCI(2),
    OBJECT(3);

    private static Logger logger;
    private static Map<Integer, BusinessServiceCheckType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(BusinessServiceCheckType.class);
        lookupTable = new HashMap<Integer, BusinessServiceCheckType>();
        BusinessServiceCheckType[] businessServiceCheckTypeArray = BusinessServiceCheckType.values();
        int n = businessServiceCheckTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BusinessServiceCheckType element = businessServiceCheckTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private BusinessServiceCheckType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static BusinessServiceCheckType getByValue(int value) {
        BusinessServiceCheckType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return NONE;
        }
        return element;
    }
}

