/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.netxms.nxmc.base.widgets.LabeledControl;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.resources.SharedIcons;
import org.xnap.commons.i18n.I18n;

public class PasswordInputField
extends LabeledControl {
    private I18n i18n = LocalizationHelper.getI18n(PasswordInputField.class);
    private Composite composite;
    private Text text;
    private Button buttonShow;
    private Button buttonCopyToClipboard;
    private boolean enabled = true;

    public PasswordInputField(Composite parent, int style, boolean showCopyOption) {
        super(parent, style, 0x400804, -1, (Object)showCopyOption);
        this.buttonShow.setToolTipText(this.i18n.tr("Show"));
        if (this.buttonCopyToClipboard != null) {
            this.buttonCopyToClipboard.setToolTipText(this.i18n.tr("Copy to clipboard"));
        }
    }

    public PasswordInputField(Composite parent, int style) {
        this(parent, style, false);
    }

    protected Control createControl(int controlStyle, Object parameters) {
        int heightHint;
        boolean showCopyOption = (Boolean)parameters;
        this.composite = new Composite((Composite)this, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = showCopyOption ? 3 : 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        this.composite.setLayout((Layout)layout);
        this.text = new Text(this.composite, controlStyle);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.buttonShow = new Button(this.composite, 8);
        this.buttonShow.setImage(SharedIcons.IMG_SHOW);
        GridData gd = new GridData(0x1000000, 0x1000000, false, false);
        gd.heightHint = heightHint = this.text.computeSize((int)-1, (int)-1).y;
        this.buttonShow.setLayoutData((Object)gd);
        this.buttonShow.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        if (showCopyOption) {
            this.buttonCopyToClipboard = new Button(this.composite, 8);
            this.buttonCopyToClipboard.setImage(SharedIcons.IMG_COPY_TO_CLIPBOARD);
            gd = new GridData(0x1000000, 0x1000000, false, false);
            gd.heightHint = heightHint;
            this.buttonCopyToClipboard.setLayoutData((Object)gd);
            this.buttonCopyToClipboard.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.composite;
    }

    public void setText(String newText) {
        this.text.setText(newText);
    }

    public String getText() {
        return this.text.getText();
    }

    private void togglePasswordVisibility() {
        int style = this.text.getStyle();
        String content = this.text.getText();
        this.text.dispose();
        if ((style & 0x400000) != 0) {
            this.text = new Text(this.composite, style & 0xFFBFFFFF);
            this.buttonShow.setImage(SharedIcons.IMG_HIDE);
            this.buttonShow.setToolTipText(this.i18n.tr("Hide"));
        } else {
            this.text = new Text(this.composite, style | 0x400000);
            this.buttonShow.setImage(SharedIcons.IMG_SHOW);
            this.buttonShow.setToolTipText(this.i18n.tr("Show"));
        }
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.text.moveAbove(null);
        this.text.setText(content);
        this.text.setEnabled(this.enabled);
        this.composite.layout(true, true);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }

    public boolean isEditable() {
        return this.text.getEditable();
    }

    public void setInputControlsEnabled(boolean enabled) {
        this.enabled = enabled;
        this.text.setEnabled(enabled);
        this.buttonShow.setEnabled(enabled);
    }
}

