/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.base.widgets;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.nxmc.base.widgets.helpers.LineStyleEvent;
import org.netxms.nxmc.base.widgets.helpers.LineStyleListener;
import org.netxms.nxmc.base.widgets.helpers.StyleRange;
import org.netxms.nxmc.tools.RefreshTimer;
import org.netxms.nxmc.tools.WidgetHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StyledText
extends Composite {
    private static final Logger logger = LoggerFactory.getLogger(StyledText.class);
    private final Browser textArea;
    private final RefreshTimer refreshTimer;
    private StringBuilder content = new StringBuilder();
    private Map<Integer, StyleRange> styleRanges = new TreeMap();
    private int writePosition = 0;
    private boolean refreshContent = false;
    private boolean refreshInProgress = false;
    private Set<LineStyleListener> lineStyleListeners = new HashSet(0);
    private boolean scrollOnAppend = false;

    public StyledText(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.textArea = new Browser((Composite)this, 0);
        this.textArea.setText("<pre id=\"textArea\"></pre>");
        this.refreshTimer = new RefreshTimer(200, (Control)this, (Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setText(String text) {
        this.checkWidget();
        this.styleRanges.clear();
        this.content = new StringBuilder(text);
        this.writePosition = 0;
        this.refreshContent = true;
        this.fireLineStyleListeners(0);
        this.refreshTimer.execute();
    }

    public void append(String text) {
        this.checkWidget();
        int pos = this.content.length();
        this.content.append(text);
        this.fireLineStyleListeners(pos);
        this.refreshTimer.execute();
    }

    public void setStyleRange(StyleRange range) {
        this.checkWidget();
        if (range.start < 0 || range.start >= this.content.length() || range.length == 0) {
            return;
        }
        this.styleRanges.put(range.start, range);
        if (range.start <= this.writePosition) {
            this.refreshContent = true;
        }
        this.refreshTimer.execute();
    }

    public int getCharCount() {
        return this.content.length();
    }

    public Control getControl() {
        return this.textArea;
    }

    public void setBackground(Color background) {
        this.textArea.setBackground(background);
    }

    public boolean setFocus() {
        return this.textArea.setFocus();
    }

    public boolean isScrollOnAppend() {
        return this.scrollOnAppend;
    }

    public void setScrollOnAppend(boolean scrollOnAppend) {
        this.scrollOnAppend = scrollOnAppend;
    }

    private String applyStyleRange(StyleRange range, String text) {
        if (range.hidden) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<span style=\"");
        if (range.foreground != null) {
            sb.append("color:rgb(");
            sb.append(range.foreground.getRed());
            sb.append(',');
            sb.append(range.foreground.getGreen());
            sb.append(',');
            sb.append(range.foreground.getBlue());
            sb.append(");");
        }
        if (range.background != null) {
            sb.append("background-color:rgb(");
            sb.append(range.background.getRed());
            sb.append(',');
            sb.append(range.background.getGreen());
            sb.append(',');
            sb.append(range.background.getBlue());
            sb.append(");");
        }
        if (range.fontStyle == 1) {
            sb.append("font:bold;");
        }
        if (range.underline) {
            sb.append("text-decoration: underline;");
        }
        if (range.strikeout) {
            sb.append("text-decoration: line-through;");
        }
        sb.append("\">");
        sb.append(text);
        sb.append("</span>");
        return sb.toString();
    }

    private String applyStyleRanges(int startPos) {
        StringBuilder result = new StringBuilder();
        int currPos = startPos;
        for (StyleRange r : this.styleRanges.values()) {
            if (r.start + r.length <= currPos) continue;
            if (currPos < r.start) {
                result.append(WidgetHelper.escapeText((String)this.content.substring(currPos, r.start), (boolean)true, (boolean)true));
            }
            result.append(this.applyStyleRange(r, WidgetHelper.escapeText((String)this.content.substring(r.start, r.start + r.length), (boolean)true, (boolean)true)));
            currPos = r.start + r.length;
        }
        result.append(WidgetHelper.escapeText((String)this.content.substring(currPos), (boolean)true, (boolean)true));
        return result.toString();
    }

    private void refresh() {
        boolean success;
        if (this.refreshInProgress) {
            this.refreshTimer.execute();
            return;
        }
        this.refreshInProgress = true;
        try {
            StringBuilder js = new StringBuilder("document.getElementById(\"textArea\").innerHTML");
            if (this.refreshContent) {
                js.append("='");
                js.append(this.applyStyleRanges(0));
            } else {
                js.append("+='");
                js.append(this.applyStyleRanges(this.writePosition));
            }
            js.append("';");
            if (this.scrollOnAppend) {
                js.append("window.scrollTo(0, document.body.scrollHeight);");
            }
            int contentLength = this.content.length();
            success = this.textArea.execute(js.toString());
            if (success) {
                this.writePosition = contentLength;
                this.refreshContent = false;
            }
        }
        catch (Exception e) {
            logger.error("Exception during StyledText content update", (Throwable)e);
            success = false;
        }
        this.refreshInProgress = false;
        if (!success) {
            this.refreshTimer.execute();
        }
    }

    public void addLineStyleListener(LineStyleListener listener) {
        this.lineStyleListeners.add(listener);
    }

    public void removeLineStyleListener(LineStyleListener listener) {
        this.lineStyleListeners.remove(listener);
    }

    private void styleLine(String line, int lineStartPos) {
        LineStyleEvent e = new LineStyleEvent();
        e.lineText = line;
        for (LineStyleListener l : this.lineStyleListeners) {
            l.lineGetStyle(e);
        }
        if (e.styles != null) {
            for (StyleRange r : e.styles) {
                r.start += lineStartPos;
                this.styleRanges.put(r.start, r);
            }
        }
    }

    protected void fireLineStyleListeners(int startPos) {
        if (this.lineStyleListeners.isEmpty()) {
            return;
        }
        StringBuilder line = new StringBuilder();
        int lineStartPos = startPos;
        char[] text = this.content.substring(startPos).toCharArray();
        for (int i = 0; i < text.length; ++i) {
            if (text[i] == '\n') {
                this.styleLine(line.toString(), lineStartPos);
                lineStartPos = startPos + i + 1;
                line = new StringBuilder();
                continue;
            }
            if (text[i] == '\r') continue;
            line.append(text[i]);
        }
        if (line.length() > 0) {
            this.styleLine(line.toString(), lineStartPos);
        }
    }

    public String getText() {
        return this.content.toString();
    }
}

