/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.agentmanagement.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.AgentTunnel;
import org.netxms.client.NXCObjectCreationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelListComparator;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelListLabelProvider;
import org.netxms.nxmc.modules.agentmanagement.views.helpers.TunnelManagerFilter;
import org.netxms.nxmc.modules.objects.dialogs.CreateNodeDialog;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class TunnelManager
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(TunnelManager.class);
    public static final String ID = "TunnelManager";
    public static final int COL_ID = 0;
    public static final int COL_STATE = 1;
    public static final int COL_NODE = 2;
    public static final int COL_IP_ADDRESS = 3;
    public static final int COL_CHANNELS = 4;
    public static final int COL_SYSNAME = 5;
    public static final int COL_HOSTNAME = 6;
    public static final int COL_PLATFORM = 7;
    public static final int COL_SYSINFO = 8;
    public static final int COL_HARDWARE_ID = 9;
    public static final int COL_AGENT_VERSION = 10;
    public static final int COL_AGENT_ID = 11;
    public static final int COL_AGENT_PROXY = 12;
    public static final int COL_SNMP_PROXY = 13;
    public static final int COL_SNMP_TRAP_PROXY = 14;
    public static final int COL_SYSLOG_PROXY = 15;
    public static final int COL_USER_AGENT = 16;
    public static final int COL_CERTIFICATE_EXPIRATION = 17;
    public static final int COL_CONNECTION_TIME = 18;
    private SortableTableViewer viewer;
    private TunnelManagerFilter filter;
    private Action actionCreateNode;
    private Action actionBind;
    private Action actionUnbind;
    private Action actionHideNonProxy;
    private Action actionHideNonUA;

    public TunnelManager() {
        super(i18n.tr("Agent Tunnels"), ResourceManager.getImageDescriptor((String)"icons/config-views/tunnel_manager.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("State"), i18n.tr("Node"), i18n.tr("IP address"), i18n.tr("Channels"), i18n.tr("System name"), i18n.tr("Hostname"), i18n.tr("Platform"), i18n.tr("System information"), i18n.tr("Hardware ID"), i18n.tr("Agent version"), i18n.tr("Agent ID"), i18n.tr("Agent proxy"), i18n.tr("SNMP proxy"), i18n.tr("SNMP trap proxy"), i18n.tr("Syslog proxy"), i18n.tr("User agent"), i18n.tr("Certificate expiration"), i18n.tr("Connection time")};
        int[] widths = new int[]{80, 80, 140, 150, 80, 150, 150, 250, 300, 180, 150, 150, 80, 80, 80, 80, 80, 130, 130};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TunnelListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new TunnelListComparator());
        this.filter = new TunnelManagerFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createPopupMenu();
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    private void createActions() {
        this.actionCreateNode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionBind = new /* Unavailable Anonymous Inner Class!! */;
        this.actionUnbind = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideNonProxy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionHideNonUA = new /* Unavailable Anonymous Inner Class!! */;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && !((AgentTunnel)selection.getFirstElement()).isBound()) {
            manager.add((IAction)this.actionBind);
            manager.add((IAction)this.actionCreateNode);
            manager.add((IContributionItem)new Separator());
        } else {
            for (Object o : selection.toList()) {
                if (!((AgentTunnel)o).isBound()) continue;
                manager.add((IAction)this.actionUnbind);
                manager.add((IContributionItem)new Separator());
                break;
            }
        }
        manager.add((IAction)this.actionHideNonProxy);
        manager.add((IAction)this.actionHideNonUA);
    }

    public void refresh() {
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNode() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        CreateNodeDialog dlg = new CreateNodeDialog(this.getWindow().getShell(), null);
        dlg.setEnableShowAgainFlag(false);
        dlg.setObjectName(tunnel.getSystemName());
        dlg.setZoneUIN(tunnel.getZoneUIN());
        if (dlg.open() != 0) {
            return;
        }
        NXCObjectCreationData cd = new NXCObjectCreationData(2, dlg.getObjectName(), 2L);
        cd.setCreationFlags(dlg.getCreationFlags());
        cd.setPrimaryName(dlg.getHostName());
        cd.setAgentPort(dlg.getAgentPort());
        cd.setSnmpPort(dlg.getSnmpPort());
        cd.setAgentProxyId(dlg.getAgentProxy());
        cd.setSnmpProxyId(dlg.getSnmpProxy());
        cd.setIcmpProxyId(dlg.getIcmpProxy());
        cd.setSshProxyId(dlg.getSshProxy());
        cd.setWebServiceProxyId(dlg.getWebServiceProxy());
        cd.setZoneUIN(dlg.getZoneUIN());
        cd.setSshLogin(dlg.getSshLogin());
        cd.setSshPassword(dlg.getSshPassword());
        cd.setSshPort(dlg.getSshPort());
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void bindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentTunnel tunnel = (AgentTunnel)selection.getFirstElement();
        if (tunnel.isBound()) {
            return;
        }
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getWindow().getShell(), ObjectSelectionDialog.createNodeSelectionFilter((boolean)false));
        if (dlg.open() != 0) {
            return;
        }
        long nodeId = ((AbstractObject)dlg.getSelectedObjects().get(0)).getObjectId();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void unbindTunnel() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Unbind Tunnel"), (String)i18n.tr("Selected tunnels will be unbound. Are you sure?"))) {
            return;
        }
        Object[] tunnels = selection.toArray();
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

