/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.alarms.widgets.helpers;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.TreeColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.events.AlarmHandle;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.interfaces.ZoneMember;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class AlarmComparator
extends ViewerComparator {
    private I18n i18n = LocalizationHelper.getI18n(AlarmComparator.class);

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc;
        TreeColumn sortColumn = ((TreeViewer)viewer).getTree().getSortColumn();
        if (sortColumn == null) {
            return 0;
        }
        switch ((Integer)sortColumn.getData("ID")) {
            case 0: {
                rc = ((AlarmHandle)e1).alarm.getCurrentSeverity().compareTo((Enum)((AlarmHandle)e2).alarm.getCurrentSeverity());
                break;
            }
            case 1: {
                rc = Integer.signum(((AlarmHandle)e1).alarm.getState() - ((AlarmHandle)e2).alarm.getState());
                break;
            }
            case 2: {
                AbstractObject obj1 = Registry.getSession().findObjectById(((AlarmHandle)e1).alarm.getSourceObjectId());
                AbstractObject obj2 = Registry.getSession().findObjectById(((AlarmHandle)e2).alarm.getSourceObjectId());
                String name1 = obj1 != null ? obj1.getObjectName() : this.i18n.tr("Unknown");
                String name2 = obj2 != null ? obj2.getObjectName() : this.i18n.tr("Unknown");
                rc = name1.compareToIgnoreCase(name2);
                break;
            }
            case 4: {
                rc = ((AlarmHandle)e1).alarm.getMessage().compareToIgnoreCase(((AlarmHandle)e2).alarm.getMessage());
                break;
            }
            case 5: {
                rc = Integer.signum(((AlarmHandle)e1).alarm.getRepeatCount() - ((AlarmHandle)e2).alarm.getRepeatCount());
                break;
            }
            case 9: {
                rc = ((AlarmHandle)e1).alarm.getCreationTime().compareTo(((AlarmHandle)e2).alarm.getCreationTime());
                break;
            }
            case 10: {
                rc = ((AlarmHandle)e1).alarm.getLastChangeTime().compareTo(((AlarmHandle)e2).alarm.getLastChangeTime());
                break;
            }
            case 3: {
                NXCSession session = Registry.getSession();
                if (session.isZoningEnabled()) {
                    ZoneMember o1 = (ZoneMember)session.findObjectById(((AlarmHandle)e1).alarm.getSourceObjectId(), ZoneMember.class);
                    ZoneMember o2 = (ZoneMember)session.findObjectById(((AlarmHandle)e2).alarm.getSourceObjectId(), ZoneMember.class);
                    String n1 = o1 != null ? o1.getZoneName() : "";
                    String n2 = o2 != null ? o2.getZoneName() : "";
                    rc = n1.compareToIgnoreCase(n2);
                    break;
                }
                rc = 0;
                break;
            }
            default: {
                rc = 0;
            }
        }
        int dir = ((TreeViewer)viewer).getTree().getSortDirection();
        return dir == 128 ? rc : -rc;
    }

    public boolean isSorterProperty(Object element, String property) {
        return true;
    }
}

