/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.charts.widgets;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.netxms.client.constants.Severity;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.nxmc.modules.charts.api.DataSeries;
import org.netxms.nxmc.modules.charts.api.GaugeColorMode;
import org.netxms.nxmc.modules.charts.widgets.Chart;
import org.netxms.nxmc.modules.charts.widgets.GenericGauge;
import org.netxms.nxmc.modules.charts.widgets.TextGauge;
import org.netxms.nxmc.resources.StatusDisplayInfo;
import org.netxms.nxmc.tools.WidgetHelper;

public class TextGauge
extends GenericGauge {
    private Font[] valueFonts = null;

    public TextGauge(Chart parent) {
        super(parent);
    }

    protected void createFonts() {
        String fontName = this.chart.getConfiguration().getFontName();
        this.valueFonts = new Font[32];
        for (int i = 0; i < this.valueFonts.length; ++i) {
            this.valueFonts[i] = new Font((Device)this.getDisplay(), fontName, i * 6 + 12, 1);
        }
    }

    protected void disposeFonts() {
        if (this.valueFonts != null) {
            for (int i = 0; i < this.valueFonts.length; ++i) {
                this.valueFonts[i].dispose();
            }
        }
    }

    protected void renderElement(GC gc, ChartConfiguration config, GraphItem dci, DataSeries data, int x, int y, int w, int h) {
        Rectangle rect = new Rectangle(x + 5, y + 5, w - 10, h - 10);
        gc.setAntialias(1);
        if (config.isElementBordersVisible()) {
            gc.setForeground(this.chart.getColorFromPreferences("Chart.Axis.Y.Color"));
            gc.drawRectangle(rect);
            rect.x += 5;
            rect.y += 5;
            rect.width -= 10;
            rect.height -= 10;
        }
        if (config.areLabelsVisible()) {
            rect.height -= gc.textExtent((String)"MMM").y + 8;
        }
        String value = this.getValueAsDisplayString(dci, data);
        Font font = WidgetHelper.getBestFittingFont((GC)gc, (Font[])this.valueFonts, (String)value, (int)rect.width, (int)rect.height);
        gc.setFont(font);
        switch (1.$SwitchMap$org$netxms$nxmc$modules$charts$api$GaugeColorMode[GaugeColorMode.getByValue((int)config.getGaugeColorMode()).ordinal()]) {
            case 1: {
                if (data.getCurrentValue() <= config.getLeftRedZone() || data.getCurrentValue() >= config.getRightRedZone()) {
                    gc.setForeground(this.chart.getColorCache().create(RED_ZONE_COLOR));
                    break;
                }
                if (data.getCurrentValue() <= config.getLeftYellowZone() || data.getCurrentValue() >= config.getRightYellowZone()) {
                    gc.setForeground(this.chart.getColorCache().create(YELLOW_ZONE_COLOR));
                    break;
                }
                gc.setForeground(this.chart.getColorCache().create(GREEN_ZONE_COLOR));
                break;
            }
            case 2: {
                gc.setForeground(this.chart.getColorCache().create(this.chart.getPaletteEntry(0).getRGBObject()));
                break;
            }
            case 3: {
                gc.setForeground(StatusDisplayInfo.getStatusColor((Severity)data.getActiveThresholdSeverity()));
                break;
            }
            default: {
                gc.setForeground(this.getDisplay().getSystemColor(2));
            }
        }
        Point ext = gc.textExtent(value);
        gc.drawText(value, rect.x + rect.width / 2 - ext.x / 2, rect.y + rect.height / 2 - ext.y / 2, 1);
        if (config.areLabelsVisible()) {
            gc.setFont(null);
            ext = gc.textExtent(dci.getDescription());
            gc.setForeground(this.chart.getColorFromPreferences("Chart.Colors.Legend"));
            gc.drawText(dci.getDescription(), rect.x + (rect.width - ext.x) / 2, rect.y + rect.height + 4, true);
        }
    }
}

