/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.actions;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionConfiguration;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.dialogs.CreateSnmpDciDialog;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class CreateSnmpDci
extends Action {
    private static I18n i18n = LocalizationHelper.getI18n(CreateSnmpDci.class);
    private Shell shell;
    private List<SnmpValue> objects = new ArrayList();
    private ObjectView view;

    public CreateSnmpDci(ObjectView view) {
        super(i18n.tr("Create data collection tiem..."));
        this.view = view;
    }

    public void run() {
        CreateSnmpDciDialog dlg;
        Object description;
        if (this.objects.size() == 0) {
            return;
        }
        MibObject mibObject = MibCache.findObject((String)((SnmpValue)this.objects.get(0)).getName(), (boolean)false);
        Object object = description = mibObject != null ? mibObject.getName() : ((SnmpValue)this.objects.get(0)).getName();
        if (this.objects.size() > 1) {
            description = (String)description + " @@instance@@";
        }
        if ((dlg = new CreateSnmpDciDialog(this.shell, (String)description)).open() != 0) {
            return;
        }
        NXCSession session = Registry.getSession();
        ArrayList values = new ArrayList(this.objects);
        HashSet<AbstractNode> nodes = new HashSet<AbstractNode>();
        for (SnmpValue v : values) {
            AbstractNode node = (AbstractNode)session.findObjectById(v.getNodeId(), AbstractNode.class);
            if (node == null) continue;
            nodes.add(node);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private static void createDci(NXCSession session, SnmpValue value, String description, int pollingInterval, int retentionTime, int deltaCalculation) throws Exception {
        AbstractNode node = (AbstractNode)session.findObjectById(value.getNodeId(), AbstractNode.class);
        if (node == null) {
            throw new NXCException(46);
        }
        DataCollectionConfiguration dcc = session.openDataCollectionConfiguration(node.getObjectId());
        DataCollectionItem dci = new DataCollectionItem(dcc, 0L);
        dci.setPollingScheduleType(1);
        dci.setPollingInterval(Integer.toString(pollingInterval));
        dci.setRetentionType(1);
        dci.setRetentionTime(Integer.toString(retentionTime));
        dci.setOrigin(DataOrigin.SNMP);
        dci.setDataType(CreateSnmpDci.dciTypeFromAsnType((int)value.getType()));
        dci.setStatus(0);
        dci.setDescription(description);
        dci.setDeltaCalculation(deltaCalculation);
        dci.setName(value.getName());
        dcc.modifyObject((DataCollectionObject)dci);
        dcc.close();
    }

    private static DataType dciTypeFromAsnType(int type) {
        switch (type) {
            case 65: {
                return DataType.COUNTER32;
            }
            case 70: {
                return DataType.COUNTER64;
            }
            case 66: 
            case 67: 
            case 71: {
                return DataType.UINT32;
            }
            case 2: {
                return DataType.INT32;
            }
        }
        return DataType.STRING;
    }

    public void selectionChanged(ISelection selection) {
        this.objects.clear();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() > 0) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof SnmpValue)) continue;
                this.objects.add((SnmpValue)o);
            }
            this.setEnabled(this.objects.size() > 0);
        } else {
            this.setEnabled(false);
        }
    }
}

