/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.DciSelector;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class DataSourceEditDlg
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(DataSourceEditDlg.class);
    private ChartDciConfig dci;
    private DciSelector dciSelector;
    private LabeledText name;
    private LabeledText displayFormat;
    private LabeledText dciName;
    private LabeledText dciDescription;
    private Button colorAuto;
    private Button colorCustom;
    private ColorSelector colorSelector;
    private Combo displayType;
    private Button checkShowThresholds;
    private Button checkInvertValues;
    private Button checkRawValues;
    private Button checkMultipeMatch;
    private LabeledText instance;
    private LabeledText dataColumn;
    private boolean graphIsTemplate;

    public DataSourceEditDlg(Shell parentShell, ChartDciConfig dci, boolean graphIsTemplate) {
        super(parentShell);
        this.dci = dci;
        this.graphIsTemplate = graphIsTemplate;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(i18n.tr("Edit Data Source"));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        GridData gd = new GridData();
        if (!this.graphIsTemplate) {
            this.dciSelector = new DciSelector(dialogArea, 0, false);
            this.dciSelector.setLabel(i18n.tr("Data collection item"));
            this.dciSelector.setDciId(this.dci.nodeId, this.dci.dciId);
            this.dciSelector.setDcObjectType(this.dci.type);
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 400;
            gd.horizontalSpan = 2;
            this.dciSelector.setLayoutData((Object)gd);
        }
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel(i18n.tr("Display name"));
        this.name.setText(this.dci.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.displayFormat = new LabeledText(dialogArea, 0);
        this.displayFormat.setLabel(i18n.tr("Display format"));
        this.displayFormat.setText(this.dci.displayFormat);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.displayFormat.setLayoutData((Object)gd);
        if (this.graphIsTemplate) {
            this.dciName = new LabeledText(dialogArea, 0);
            this.dciName.setLabel("DCI Name");
            this.dciName.setText(this.dci.dciName);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciName.setLayoutData((Object)gd);
            this.dciDescription = new LabeledText(dialogArea, 0);
            this.dciDescription.setLabel("DCI Description");
            this.dciDescription.setText(this.dci.dciDescription);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.dciDescription.setLayoutData((Object)gd);
        }
        if (this.dci.type == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            tableGroup.setText(i18n.tr("Table Cell"));
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            this.dataColumn.setLabel(i18n.tr("Data column"));
            this.dataColumn.setText(this.dci.column);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            this.instance.setLabel(i18n.tr("Instance"));
            this.instance.setText(this.dci.instance);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.displayType = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)i18n.tr("Display type"), (Object)gd);
        this.displayType.add("Default");
        this.displayType.add("Line");
        this.displayType.add("Area");
        this.displayType.select(this.dci.getLineChartType() + 1);
        Group optionsGroup = new Group(dialogArea, 0);
        optionsGroup.setText(i18n.tr("Options"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        gd.verticalSpan = 2;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        optionsGroup.setLayout((Layout)layout);
        this.checkShowThresholds = new Button((Composite)optionsGroup, 32);
        this.checkShowThresholds.setText(i18n.tr("Show &thresholds"));
        this.checkShowThresholds.setSelection(this.dci.showThresholds);
        this.checkInvertValues = new Button((Composite)optionsGroup, 32);
        this.checkInvertValues.setText(i18n.tr("Invert values"));
        this.checkInvertValues.setSelection(this.dci.invertValues);
        this.checkRawValues = new Button((Composite)optionsGroup, 32);
        this.checkRawValues.setText(i18n.tr("Raw values"));
        this.checkRawValues.setSelection(this.dci.useRawValues);
        if (this.graphIsTemplate) {
            this.checkMultipeMatch = new Button((Composite)optionsGroup, 32);
            this.checkMultipeMatch.setText(i18n.tr("Multiple match"));
            this.checkMultipeMatch.setSelection(this.dci.multiMatch);
        }
        Group colorGroup = new Group(dialogArea, 0);
        colorGroup.setText(i18n.tr("Color"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        colorGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        colorGroup.setLayout((Layout)layout);
        this.colorAuto = new Button((Composite)colorGroup, 16);
        this.colorAuto.setText(i18n.tr("&Automatic color"));
        this.colorAuto.setSelection(this.dci.color.equalsIgnoreCase("UNSET"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.colorAuto.setLayoutData((Object)gd);
        this.colorAuto.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.colorCustom = new Button((Composite)colorGroup, 16);
        this.colorCustom.setText(i18n.tr("&Custom color:"));
        this.colorCustom.setSelection(!this.dci.color.equalsIgnoreCase("UNSET"));
        this.colorCustom.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.colorSelector = new ColorSelector((Composite)colorGroup);
        this.colorSelector.setColorValue(ColorConverter.rgbFromInt((int)this.dci.getColorAsInt()));
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.grabExcessHorizontalSpace = true;
        this.colorSelector.getButton().setLayoutData((Object)gd);
        this.colorSelector.setEnabled(!this.dci.color.equalsIgnoreCase("UNSET"));
        return dialogArea;
    }

    protected void okPressed() {
        if (this.graphIsTemplate) {
            this.dci.dciName = this.dciName.getText();
            this.dci.dciDescription = this.dciDescription.getText();
            this.dci.multiMatch = this.checkMultipeMatch.getSelection();
        } else {
            this.dci.nodeId = this.dciSelector.getNodeId();
            this.dci.dciId = this.dciSelector.getDciId();
        }
        this.dci.name = this.name.getText();
        this.dci.displayFormat = this.displayFormat.getText();
        this.dci.color = this.colorAuto.getSelection() ? "UNSET" : "0x" + Integer.toHexString(ColorConverter.rgbToInt((RGB)this.colorSelector.getColorValue()));
        this.dci.lineChartType = this.displayType.getSelectionIndex() - 1;
        this.dci.showThresholds = this.checkShowThresholds.getSelection();
        this.dci.invertValues = this.checkInvertValues.getSelection();
        this.dci.useRawValues = this.checkRawValues.getSelection();
        if (this.dci.type == 2) {
            this.dci.column = this.dataColumn.getText().trim();
            this.dci.instance = this.instance.getText();
        }
        super.okPressed();
    }
}

