/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.imagelibrary.dialogs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.base.NXCommon;
import org.netxms.client.LibraryImage;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.ImageProvider;
import org.netxms.nxmc.modules.imagelibrary.ImageUpdateListener;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageCategory;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageLibraryContentProvider;
import org.netxms.nxmc.modules.imagelibrary.views.helpers.ImageLibraryLabelProvider;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImagePreview;
import org.xnap.commons.i18n.I18n;

public class ImageSelectionDialog
extends Dialog
implements ImageUpdateListener {
    private static final String SELECT_IMAGE_CY = "SelectImage.cy";
    private static final String SELECT_IMAGE_CX = "SelectImage.cx";
    private static final int DEFAULT_ID = 1025;
    private I18n i18n = LocalizationHelper.getI18n(ImageSelectionDialog.class);
    private Map<String, ImageCategory> imageCategories = new HashMap();
    private TreeViewer viewer;
    private ImagePreview imagePreview;
    private LibraryImage image;
    private boolean allowDefault;

    public ImageSelectionDialog(Shell parentShell) {
        this(parentShell, false);
    }

    public ImageSelectionDialog(Shell parentShell, boolean allowDefault) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.allowDefault = allowDefault;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.i18n.tr("Select Image"));
        PreferenceStore settings = PreferenceStore.getInstance();
        newShell.setSize(settings.getAsInteger(SELECT_IMAGE_CX, 700), settings.getAsInteger(SELECT_IMAGE_CY, 400));
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TreeViewer(dialogArea, 67584);
        this.viewer.setContentProvider((IContentProvider)new ImageLibraryContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ImageLibraryLabelProvider());
        this.viewer.setComparator((ViewerComparator)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gd);
        this.imagePreview = new ImagePreview(dialogArea, 2048);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.widthHint = 300;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.imagePreview.setLayoutData((Object)gd);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        ImageProvider.getInstance().addUpdateListener((ImageUpdateListener)this);
        dialogArea.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.refreshImages();
        return dialogArea;
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty() || !(selection.getFirstElement() instanceof LibraryImage)) {
            return;
        }
        this.image = (LibraryImage)selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    private void defaultPressed() {
        this.image = new LibraryImage();
        this.saveSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (1025 == buttonId) {
            this.defaultPressed();
        }
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        PreferenceStore settings = PreferenceStore.getInstance();
        settings.set(SELECT_IMAGE_CX, size.x);
        settings.set(SELECT_IMAGE_CY, size.y);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.allowDefault) {
            this.createButton(parent, 1025, this.i18n.tr("&Default"), false);
        }
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void refreshImages() {
        ImageProvider provider = ImageProvider.getInstance();
        List imageLibrary = provider.getImageLibrary();
        this.imageCategories.clear();
        for (LibraryImage image : imageLibrary) {
            ImageCategory category = (ImageCategory)this.imageCategories.get(image.getCategory());
            if (category == null) {
                category = new ImageCategory(image.getCategory());
                this.imageCategories.put(category.getName(), category);
            }
            category.addImage(image);
        }
        this.viewer.setInput((Object)this.imageCategories);
    }

    public UUID getImageGuid() {
        return this.image == null ? NXCommon.EMPTY_GUID : this.image.getGuid();
    }

    public LibraryImage getImage() {
        return this.image;
    }

    public void imageUpdated(UUID guid) {
        if (this.getShell().isDisposed()) {
            return;
        }
        LibraryImage image = ImageProvider.getInstance().getLibraryImageObject(guid);
        if (image != null) {
            this.getShell().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Button access$000(ImageSelectionDialog x0, int x1) {
        return x0.getButton(x1);
    }
}

