/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.client.objects.BusinessServiceRoot;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.NetworkMapGroup;
import org.netxms.client.objects.NetworkMapRoot;
import org.netxms.client.objects.Node;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.client.objects.TemplateGroup;
import org.netxms.client.objects.TemplateRoot;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.ObjectCreateMenuManager;
import org.netxms.nxmc.modules.objects.ObjectFilter;
import org.xnap.commons.i18n.I18n;

public class ObjectCreateMenuManager
extends MenuManager {
    private static final I18n i18n = LocalizationHelper.getI18n(ObjectCreateMenuManager.class);
    private Shell shell;
    private View view;
    private AbstractObject parent;
    private long parentId;
    private Action actionCreateBusinessService;
    private Action actionCreateBusinessServicePrototype;
    private Action actionCreateChassis;
    private Action actionCreateCluster;
    private Action actionCreateCondition;
    private Action actionCreateContainer;
    private Action actionCreateInterface;
    private Action actionCreateMobileDevice;
    private Action actionCreateNetworkMap;
    private Action actionCreateNetworkMapGroup;
    private Action actionCreateNode;
    private Action actionCreateRack;
    private Action actionCreateTemplate;
    private Action actionCreateTemplateGroup;
    private Action actionCreateVpnConnector;

    public ObjectCreateMenuManager(Shell shell, View view, AbstractObject parent) {
        this.shell = shell;
        this.view = view;
        this.parent = parent;
        this.parentId = parent.getObjectId();
        this.setMenuText(i18n.tr("&Create"));
        this.createActions();
        this.addAction((IMenuManager)this, this.actionCreateBusinessService, o -> o instanceof BusinessService || o instanceof BusinessServiceRoot && !(o instanceof BusinessServicePrototype));
        this.addAction((IMenuManager)this, this.actionCreateBusinessServicePrototype, o -> o instanceof BusinessService || o instanceof BusinessServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateChassis, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateCluster, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateCondition, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateContainer, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateInterface, o -> o instanceof Node);
        this.addAction((IMenuManager)this, this.actionCreateMobileDevice, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateNetworkMap, o -> o instanceof NetworkMapGroup || o instanceof NetworkMapRoot);
        this.addAction((IMenuManager)this, this.actionCreateNetworkMapGroup, o -> o instanceof NetworkMapGroup || o instanceof NetworkMapRoot);
        this.addAction((IMenuManager)this, this.actionCreateNode, o -> o instanceof Cluster || o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateRack, o -> o instanceof Container || o instanceof ServiceRoot);
        this.addAction((IMenuManager)this, this.actionCreateTemplate, o -> o instanceof TemplateGroup || o instanceof TemplateRoot);
        this.addAction((IMenuManager)this, this.actionCreateTemplateGroup, o -> o instanceof TemplateGroup || o instanceof TemplateRoot);
        this.addAction((IMenuManager)this, this.actionCreateVpnConnector, o -> o instanceof Node);
    }

    protected void createActions() {
        this.actionCreateBusinessService = new GenericObjectCreationAction(this, i18n.tr("&Business service..."), 28, i18n.tr("Business Service"));
        this.actionCreateBusinessServicePrototype = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateChassis = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateCluster = new GenericObjectCreationAction(this, i18n.tr("C&luster..."), 14, i18n.tr("Cluster"));
        this.actionCreateCondition = new GenericObjectCreationAction(this, i18n.tr("C&ondition..."), 13, i18n.tr("Condition"));
        this.actionCreateContainer = new GenericObjectCreationAction(this, i18n.tr("&Container..."), 5, i18n.tr("Container"));
        this.actionCreateInterface = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateMobileDevice = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateNetworkMap = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateNetworkMapGroup = new GenericObjectCreationAction(this, i18n.tr("Network map &group..."), 20, i18n.tr("Network Map Group"));
        this.actionCreateNode = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCreateRack = new GenericObjectCreationAction(this, i18n.tr("&Rack..."), 32, i18n.tr("Rack"));
        this.actionCreateTemplate = new GenericObjectCreationAction(this, i18n.tr("&Template..."), 8, i18n.tr("Template"));
        this.actionCreateTemplateGroup = new GenericObjectCreationAction(this, i18n.tr("Template &group..."), 9, i18n.tr("Template Group"));
        this.actionCreateVpnConnector = new GenericObjectCreationAction(this, i18n.tr("&VPN connector..."), 12, i18n.tr("VPN Connector"));
    }

    protected void addAction(IMenuManager manager, Action action, ObjectFilter filter) {
        if (filter.accept(this.parent)) {
            manager.add((IAction)action);
        }
    }
}

