/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.ClusterResource;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.dialogs.ClusterResourceEditDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.helpers.ResourceListComparator;
import org.netxms.nxmc.modules.objects.propertypages.helpers.ResourceListLabelProvider;
import org.xnap.commons.i18n.I18n;

public class ClusterResources
extends ObjectPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(ClusterResources.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_IP_ADDRESS = 1;
    private Cluster cluster;
    private SortableTableViewer viewer;
    private Button addButton;
    private Button editButton;
    private Button deleteButton;
    private List<ClusterResource> resources = null;
    private boolean isModified = false;

    public ClusterResources(AbstractObject object) {
        super(i18n.tr("Cluster Resources"), object);
    }

    public String getId() {
        return "clusterResources";
    }

    public int getPriority() {
        return 10;
    }

    public boolean isVisible() {
        return this.object instanceof Cluster;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.cluster = (Cluster)this.object;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        String[] columnNames = new String[]{i18n.tr("Name"), i18n.tr("Virtual IP")};
        int[] columnWidths = new int[]{250, 150};
        this.viewer = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 67586);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResourceListLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ResourceListComparator());
        this.resources = new ArrayList(this.cluster.getResources().size());
        for (ClusterResource r : this.cluster.getResources()) {
            this.resources.add(new ClusterResource(r));
        }
        this.viewer.setInput((Object)this.resources.toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.viewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(i18n.tr("&Add..."));
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.addButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editButton = new Button(buttons, 8);
        this.editButton.setText(i18n.tr("&Modify..."));
        rd = new RowData();
        rd.width = 90;
        this.editButton.setLayoutData((Object)rd);
        this.editButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.deleteButton = new Button(buttons, 8);
        this.deleteButton.setText(i18n.tr("&Delete"));
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        this.deleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        return dialogArea;
    }

    private void addResource() {
        ClusterResourceEditDialog dlg = new ClusterResourceEditDialog(this.getShell(), null);
        if (dlg.open() == 0) {
            long id = 1L;
            for (ClusterResource r : this.resources) {
                if (r.getId() < id) continue;
                id = r.getId() + 1L;
            }
            ClusterResource r = new ClusterResource(id, dlg.getName(), dlg.getAddress());
            this.resources.add(r);
            this.viewer.setInput((Object)this.resources.toArray());
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)r));
            this.isModified = true;
        }
    }

    private void editResource() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        ClusterResource r = (ClusterResource)selection.getFirstElement();
        ClusterResourceEditDialog dlg = new ClusterResourceEditDialog(this.getShell(), r);
        if (dlg.open() == 0) {
            r.setName(dlg.getName());
            r.setVirtualAddress(dlg.getAddress());
            this.viewer.update((Object)r, null);
            this.isModified = true;
        }
    }

    private void deleteResource() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        for (Object o : selection.toList()) {
            this.resources.remove(o);
        }
        this.viewer.setInput((Object)this.resources.toArray());
        this.isModified = true;
    }

    protected boolean applyChanges(boolean isApply) {
        if (!this.isModified) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setResourceList(this.resources);
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

