/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.base.NXCommon;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.AccessPoint;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.Chassis;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Condition;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.MobileDevice;
import org.netxms.client.objects.NetworkMap;
import org.netxms.client.objects.Rack;
import org.netxms.client.objects.Sensor;
import org.netxms.client.objects.Subnet;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.imagelibrary.widgets.ImageSelector;
import org.netxms.nxmc.modules.objects.dialogs.ObjectSelectionDialog;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.xnap.commons.i18n.I18n;

public class MapAppearance
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(MapAppearance.class);
    private LabeledText nameOnMap;
    private ImageSelector image;
    private ObjectSelector drillDownObject = null;

    public MapAppearance(AbstractObject object) {
        super(i18n.tr("Map Appearance"), object);
    }

    public String getId() {
        return "mapAppearance";
    }

    public boolean isVisible() {
        return this.object instanceof AbstractNode || this.object instanceof AccessPoint || this.object instanceof BusinessService || this.object instanceof Chassis || this.object instanceof Cluster || this.object instanceof Condition || this.object instanceof Container || this.object instanceof MobileDevice || this.object instanceof NetworkMap || this.object instanceof Rack || this.object instanceof Sensor || this.object instanceof Subnet;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.nameOnMap = new LabeledText(dialogArea, 0);
        this.nameOnMap.setLabel("Name on network maps (leave empty to use normal object name)");
        this.nameOnMap.setText(this.object.getConfiguredNameOnMap());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.nameOnMap.setLayoutData((Object)gd);
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel(i18n.tr("Presentation image"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        this.image.setImageGuid(this.object.getMapImage(), false);
        if (!(this.object instanceof NetworkMap)) {
            this.drillDownObject = new ObjectSelector(dialogArea, 0, true);
            this.drillDownObject.setLabel("Drill-down object");
            this.drillDownObject.setObjectClass(AbstractObject.class);
            this.drillDownObject.setObjectId(this.object.getDrillDownObjectId());
            this.drillDownObject.setClassFilter(ObjectSelectionDialog.createDashboardAndNetworkMapSelectionFilter());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.drillDownObject.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        NXCObjectModificationData data = new NXCObjectModificationData(this.object.getObjectId());
        data.setNameOnMap(this.nameOnMap.getText().trim());
        data.setMapImage(this.image.getImageGuid());
        if (this.drillDownObject != null) {
            data.setDrillDownObjectId(this.drillDownObject.getObjectId());
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.nameOnMap.setText("");
        this.image.setImageGuid(NXCommon.EMPTY_GUID, true);
        if (!(this.object instanceof NetworkMap)) {
            this.drillDownObject.setObjectId(0L);
        }
    }
}

