/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.views;

import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.views.NodeSubObjectTableView;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListComparator;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListFilter;
import org.netxms.nxmc.modules.objects.views.helpers.InterfaceListLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class InterfacesView
extends NodeSubObjectTableView {
    private static final I18n i18n = LocalizationHelper.getI18n(InterfacesView.class);
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_ALIAS = 2;
    public static final int COLUMN_TYPE = 3;
    public static final int COLUMN_INDEX = 4;
    public static final int COLUMN_PHYSICAL_LOCATION = 5;
    public static final int COLUMN_MTU = 6;
    public static final int COLUMN_SPEED = 7;
    public static final int COLUMN_DESCRIPTION = 8;
    public static final int COLUMN_MAC_ADDRESS = 9;
    public static final int COLUMN_IP_ADDRESS = 10;
    public static final int COLUMN_VLAN = 11;
    public static final int COLUMN_PEER_NODE = 12;
    public static final int COLUMN_PEER_INTERFACE = 13;
    public static final int COLUMN_PEER_MAC_ADDRESS = 14;
    public static final int COLUMN_PEER_IP_ADDRESS = 15;
    public static final int COLUMN_PEER_PROTOCOL = 16;
    public static final int COLUMN_ADMIN_STATE = 17;
    public static final int COLUMN_OPER_STATE = 18;
    public static final int COLUMN_EXPECTED_STATE = 19;
    public static final int COLUMN_STATUS = 20;
    public static final int COLUMN_8021X_PAE_STATE = 21;
    public static final int COLUMN_8021X_BACKEND_STATE = 22;
    private InterfaceListLabelProvider labelProvider;
    private Action actionCopyMacAddressToClipboard;
    private Action actionCopyIpAddressToClipboard;
    private Action actionCopyPeerNameToClipboard;
    private Action actionCopyPeerMacToClipboard;
    private Action actionCopyPeerIpToClipboard;
    private boolean hideSubInterfaces = false;

    public InterfacesView() {
        super(i18n.tr("Interfaces"), ResourceManager.getImageDescriptor((String)"icons/object-views/interfaces.png"), "Interfaces", true);
    }

    protected void createContent(Composite parent) {
        super.createContent(parent);
        this.hideSubInterfaces = PreferenceStore.getInstance().getAsBoolean("InterfacesView.HideSubInterfaces", this.hideSubInterfaces);
    }

    protected void createViewer() {
        String[] names = new String[]{i18n.tr("ID"), i18n.tr("Name"), i18n.tr("Alias"), i18n.tr("Type"), i18n.tr("Index"), i18n.tr("Location"), i18n.tr("MTU"), i18n.tr("Speed"), i18n.tr("Description"), i18n.tr("MAC address"), i18n.tr("IP addresses"), i18n.tr("VLAN"), i18n.tr("Peer node"), i18n.tr("Peer interface"), i18n.tr("Peer MAC"), i18n.tr("Peer IP"), i18n.tr("Peer discovery protocol"), i18n.tr("Administrative state"), i18n.tr("Operational state"), i18n.tr("Expected state"), i18n.tr("Status"), i18n.tr("802.1x PAE"), i18n.tr("802.1x Backend")};
        int[] widths = new int[]{60, 150, 150, 150, 70, 100, 70, 90, 150, 100, 90, 80, 150, 150, 100, 90, 80, 80, 80, 80, 80, 80, 80};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new InterfaceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new InterfaceListComparator());
        this.filter = new InterfaceListFilter();
        ((InterfaceListFilter)this.filter).setHideSubInterfaces(this.hideSubInterfaces);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"InterfacesView.TableViewer");
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void createActions() {
        super.createActions();
        this.actionCopyMacAddressToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyIpAddressToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerNameToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerMacToClipboard = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyPeerIpToClipboard = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionCopyMacAddressToClipboard);
        manager.add((IAction)this.actionCopyIpAddressToClipboard);
        manager.add((IAction)this.actionCopyPeerNameToClipboard);
        manager.add((IAction)this.actionCopyPeerMacToClipboard);
        manager.add((IAction)this.actionCopyPeerIpToClipboard);
        manager.add((IAction)this.actionExportToCsv);
    }

    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(3).toArray());
        } else {
            this.viewer.setInput((Object)new Interface[0]);
        }
    }

    public void hideSubInterfaces(boolean hide) {
        this.hideSubInterfaces = hide;
        ((InterfaceListFilter)this.filter).setHideSubInterfaces(hide);
        this.viewer.refresh();
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isChildOf(this.getObjectId());
    }

    protected void onObjectChange(AbstractObject object) {
        this.labelProvider.setNode((AbstractNode)object);
        super.onObjectChange(object);
    }

    protected void collectObjectsForChildrenSync(AbstractObject object, Set<AbstractObject> objectsForSync) {
        super.collectObjectsForChildrenSync(object, objectsForSync);
        for (AbstractObject o : object.getAllChildren(3)) {
            AbstractObject peerNode = this.session.findObjectById(((Interface)o).getPeerNodeId());
            if (peerNode == null || peerNode.areChildrenSynchronized()) continue;
            objectsForSync.add(peerNode);
        }
    }

    public int getPriority() {
        return 50;
    }
}

