/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;

public class NotificationChannelPropertiesDialog
extends Dialog {
    private NotificationChannel nc;
    private LabeledText textName;
    private LabeledText textDescription;
    private LabeledText textConfiguraiton;
    private Combo comboDriverName;
    private boolean isNameChangeds;
    private String newName;

    public NotificationChannelPropertiesDialog(Shell parentShell, NotificationChannel nc) {
        super(parentShell);
        this.nc = nc;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel("Name");
        this.textName.getTextControl().setTextLimit(63);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        this.textDescription = new LabeledText(dialogArea, 0);
        this.textDescription.setLabel("Description");
        this.textDescription.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textDescription.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.comboDriverName = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Driver", (Object)gd);
        this.textConfiguraiton = new LabeledText(dialogArea, 0, 2050);
        this.textConfiguraiton.setLabel("Driver configuration");
        this.textConfiguraiton.getTextControl().setFont(JFaceResources.getTextFont());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.heightHint = 300;
        gd.widthHint = 900;
        this.textConfiguraiton.setLayoutData((Object)gd);
        if (this.nc != null) {
            this.textName.setText(this.nc.getName());
            this.textDescription.setText(this.nc.getDescription());
            this.textConfiguraiton.setText(this.nc.getConfiguration());
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return dialogArea;
    }

    private void updateUI(List<String> ncList) {
        for (int i = 0; i < ncList.size(); ++i) {
            this.comboDriverName.add(ncList.get(i));
            if (this.nc == null || !ncList.get(i).equals(this.nc.getDriverName())) continue;
            this.comboDriverName.select(i);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.nc != null ? "Update notification channel" : "Create notification channel");
    }

    protected void okPressed() {
        if (this.textName.getText().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Notification channel name should not be empty");
            return;
        }
        if (this.comboDriverName.getSelectionIndex() == -1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Notification driver should be selected");
            return;
        }
        if (this.nc == null) {
            this.nc = new NotificationChannel();
            this.nc.setName(this.textName.getText());
        } else if (!this.nc.getName().equals(this.textName.getText())) {
            this.isNameChangeds = true;
            this.newName = this.textName.getText();
        }
        this.nc.setDescription(this.textDescription.getText());
        this.nc.setDriverName(this.comboDriverName.getItem(this.comboDriverName.getSelectionIndex()));
        this.nc.setConfiguration(this.textConfiguraiton.getText());
        super.okPressed();
    }

    public NotificationChannel getNotificaiotnChannel() {
        return this.nc;
    }

    public boolean isNameChanged() {
        return this.isNameChangeds;
    }

    public String getNewName() {
        return this.newName;
    }
}

