/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.dialogs;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.server.ServerVariable;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.dialogs.VariableEditDialog;
import org.netxms.nxmc.tools.ColorConverter;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class VariableEditDialog
extends Dialog {
    private static final I18n i18n = LocalizationHelper.getI18n(VariableEditDialog.class);
    private LabeledText textName;
    private Text textValue;
    private Spinner spinnerValue;
    private Button buttonEnable;
    private ColorSelector colorSelector;
    private Combo comboValue;
    private ServerVariable variable;
    private Map<Integer, String> valueMap;
    private String name;
    private String value;

    public VariableEditDialog(Shell parentShell, ServerVariable variable) {
        super(parentShell);
        this.variable = variable;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textName = new LabeledText(dialogArea, 0);
        this.textName.setLabel(i18n.tr("Name"));
        this.textName.getTextControl().setTextLimit(63);
        if (this.variable.getName() != null) {
            this.textName.setText(this.variable.getName());
            this.textName.getTextControl().setEditable(false);
        }
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.textName.setLayoutData((Object)gd);
        if (!this.variable.getUnit().isEmpty()) {
            layout.numColumns = 2;
            gd.horizontalSpan = 2;
        }
        switch (1.$SwitchMap$org$netxms$client$constants$ServerVariableDataType[this.variable.getDataType().ordinal()]) {
            case 1: {
                this.buttonEnable = new Button(dialogArea, 32);
                this.buttonEnable.setText("Enable");
                this.buttonEnable.setSelection(this.variable.getValueAsBoolean());
                if (this.variable.getName() == null) break;
                this.buttonEnable.setFocus();
                break;
            }
            case 2: {
                this.valueMap = new HashMap();
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.comboValue = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)2056, (String)i18n.tr("Value"), (Object)gd);
                for (Map.Entry e : this.variable.getPossibleValues().entrySet()) {
                    this.comboValue.add((String)e.getValue());
                    int index = this.comboValue.getItemCount() - 1;
                    this.valueMap.put(index, (String)e.getKey());
                    if (!((String)e.getKey()).equals(this.variable.getValue())) continue;
                    this.comboValue.select(index);
                }
                if (this.variable.getName() == null) break;
                this.comboValue.setFocus();
                break;
            }
            case 3: {
                this.colorSelector = WidgetHelper.createLabeledColorSelector((Composite)dialogArea, (String)i18n.tr("Value"), (Object)"WidgetHelper::default_layout_data");
                if (this.variable.getValue().isEmpty()) break;
                this.colorSelector.setColorValue(ColorConverter.parseColorDefinition((String)this.variable.getValue()));
                break;
            }
            case 4: {
                this.spinnerValue = WidgetHelper.createLabeledSpinner((Composite)dialogArea, (int)2048, (String)i18n.tr("Value"), (int)0, (int)(this.variable.getPossibleValues().isEmpty() ? 0xFFFFFF : Integer.parseInt((String)this.variable.getPossibleValues().keySet().toArray()[0])), (Object)"WidgetHelper::default_layout_data");
                this.spinnerValue.setSelection(this.variable.getValueAsInt());
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.spinnerValue.setLayoutData((Object)gd);
                if (!this.variable.getUnit().isEmpty()) {
                    Label unit = new Label(dialogArea, 0);
                    unit.setText(this.variable.getUnit());
                    gd = new GridData();
                    gd.grabExcessHorizontalSpace = true;
                    gd.verticalIndent = 15;
                    gd.horizontalAlignment = 4;
                    unit.setLayoutData((Object)gd);
                }
                if (this.variable.getName() == null) break;
                this.spinnerValue.setFocus();
                break;
            }
            case 5: {
                this.textValue = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)i18n.tr("Value"), (String)this.variable.getValue(), (Object)"WidgetHelper::default_layout_data");
                this.textValue.setTextLimit(2000);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                this.textValue.setLayoutData((Object)gd);
                if (this.variable.getName() == null) break;
                this.textValue.setFocus();
            }
        }
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.variable.getName() == null ? i18n.tr("Create Variable") : i18n.tr("Edit Variable"));
    }

    public String getVarName() {
        return this.name;
    }

    public String getVarValue() {
        return this.value;
    }

    protected void okPressed() {
        this.name = this.textName.getText();
        switch (1.$SwitchMap$org$netxms$client$constants$ServerVariableDataType[this.variable.getDataType().ordinal()]) {
            case 1: {
                this.value = this.buttonEnable.getSelection() ? "1" : "0";
                break;
            }
            case 2: {
                if (this.comboValue.getSelectionIndex() == -1) {
                    MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select valid value and then press OK");
                    return;
                }
                this.value = (String)this.valueMap.get(this.comboValue.getSelectionIndex());
                break;
            }
            case 3: {
                if (this.colorSelector.getColorValue() == null) break;
                this.value = ColorConverter.rgbToCss((RGB)this.colorSelector.getColorValue());
                break;
            }
            case 4: {
                this.value = this.spinnerValue.getText();
                break;
            }
            case 5: {
                this.value = this.textValue.getText();
            }
        }
        super.okPressed();
    }
}

