/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ServerVariableDataType;
import org.netxms.client.server.ServerVariable;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.dialogs.VariableEditDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ServerVariableComparator;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ServerVariablesFilter;
import org.netxms.nxmc.modules.serverconfig.views.helpers.ServerVariablesLabelProvider;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class ServerVariables
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(ServerVariables.class);
    private static final String ID = "ServerVariables";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_DEFAULT_VALUE = 2;
    public static final int COLUMN_NEED_RESTART = 3;
    public static final int COLUMN_DESCRIPTION = 4;
    private SortableTableViewer viewer;
    private NXCSession session = Registry.getSession();
    private Map<String, ServerVariable> varList;
    private Action actionAdd;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;
    private Action actionDefaultValue;

    public ServerVariables() {
        super(i18n.tr("Server Configuration"), ResourceManager.getImageDescriptor((String)"icons/config-views/server_config.png"), ID, true);
    }

    protected void createContent(Composite parent) {
        String[] names = new String[]{i18n.tr("Name"), i18n.tr("Value"), i18n.tr("Default value"), i18n.tr("Restart"), i18n.tr("Description")};
        int[] widths = new int[]{200, 150, 150, 80, 500};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 67586, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)ID);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerVariablesLabelProvider());
        this.viewer.setComparator((ViewerComparator)new ServerVariableComparator());
        ServerVariablesFilter filter = new ServerVariablesFilter();
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addFilter((ViewerFilter)filter);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
    }

    protected void postContentCreate() {
        this.refresh();
    }

    private void createActions() {
        this.actionAdd = new /* Unavailable Anonymous Inner Class!! */;
        this.actionAdd.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.add_config_variable");
        this.actionEdit = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEdit.setEnabled(false);
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete.setEnabled(false);
        this.actionDefaultValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, false);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionAdd);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IAction)this.actionDefaultValue);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionExportToCsv);
        mgr.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    protected void fillLocalMenu(MenuManager manager) {
        manager.add((IAction)this.actionAdd);
        manager.add((IAction)this.actionExportAllToCsv);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void addVariable() {
        VariableEditDialog dlg = new VariableEditDialog(this.getWindow().getShell(), new ServerVariable(null, "", false, ServerVariableDataType.STRING, "", ""));
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void editVariable() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() != 1) {
            return;
        }
        ServerVariable var = (ServerVariable)selection.getFirstElement();
        VariableEditDialog dlg = new VariableEditDialog(this.getWindow().getShell(), var);
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void deleteVariables() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection == null || selection.size() == 0) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)i18n.tr("Confirm Delete"), (String)i18n.tr("Are you sure you want to delete selected configuration variables?"))) {
            return;
        }
        ArrayList<String> names = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof ServerVariable)) continue;
            names.add(((ServerVariable)o).getName());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void setDefaultValue() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        List list = selection.toList();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

