/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.snmp.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.actions.ExportToCsvAction;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.actions.CreateSnmpDci;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.modules.snmp.helpers.SnmpValueLabelProvider;
import org.netxms.nxmc.modules.snmp.shared.MibCache;
import org.netxms.nxmc.modules.snmp.views.MibExplorer;
import org.netxms.nxmc.modules.snmp.views.helpers.SnmpWalkFilter;
import org.netxms.nxmc.modules.snmp.widgets.MibBrowser;
import org.netxms.nxmc.modules.snmp.widgets.MibObjectDetails;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class MibExplorer
extends ObjectView
implements SnmpWalkListener {
    private static I18n i18n = LocalizationHelper.getI18n(MibExplorer.class);
    private static final String ID = "MibExplorer";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TEXT = 1;
    public static final int COLUMN_TYPE = 2;
    public static final int COLUMN_VALUE = 3;
    private Font headerFont;
    private MibBrowser mibBrowser;
    private MibObjectDetails details;
    private TableViewer viewer;
    private AbstractNode currentNode = null;
    private NXCSession session;
    private boolean walkActive = false;
    private List<SnmpValue> walkData = new ArrayList();
    private Action actionWalk;
    private Action actionCopyObjectName;
    private Action actionCopy;
    private Action actionCopyName;
    private Action actionCopySymbolicName;
    private Action actionCopyType;
    private Action actionCopyValue;
    private Action actionSelect;
    private Action actionExportToCsv;
    private CreateSnmpDci actionCreateSnmpDci;
    private Composite resultArea;
    private SnmpWalkFilter filter;

    public MibExplorer() {
        super(i18n.tr("MIB Explorer"), ResourceManager.getImageDescriptor((String)"icons/object-views/mibexplorer.gif"), ID, true);
        this.session = Registry.getSession();
    }

    public void createContent(Composite parent) {
        this.headerFont = new Font((Device)parent.getDisplay(), "Verdana", 11, 1);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        SashForm splitter = new SashForm(parent, 512);
        splitter.setLayout((Layout)new FillLayout());
        splitter.setLayoutData((Object)new GridData(4, 4, true, true));
        SashForm mibViewSplitter = new SashForm((Composite)splitter, 256);
        mibViewSplitter.setLayout((Layout)new FillLayout());
        this.mibBrowser = new MibBrowser((Composite)mibViewSplitter, 2048);
        this.mibBrowser.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.details = new MibObjectDetails((Composite)mibViewSplitter, 2048, true, this.mibBrowser);
        this.resultArea = new Composite((Composite)splitter, 2048);
        this.resultArea.setLayout((Layout)new FillLayout());
        this.viewer = new TableViewer(this.resultArea, 67586);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.setupViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpValueLabelProvider());
        this.filter = new SnmpWalkFilter();
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        splitter.setWeights(new int[]{70, 30});
        this.createActions();
        this.createTreePopupMenu();
        this.createResultsPopupMenu();
    }

    public void refresh() {
        this.mibBrowser.refreshTree();
    }

    private void createActions() {
        this.actionWalk = new /* Unavailable Anonymous Inner Class!! */;
        this.actionWalk.setEnabled(this.currentNode != null);
        this.actionCopyObjectName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopy = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopySymbolicName = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyType = new /* Unavailable Anonymous Inner Class!! */;
        this.actionCopyValue = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSelect = new /* Unavailable Anonymous Inner Class!! */;
        this.actionSelect.setEnabled(false);
        this.actionExportToCsv = new ExportToCsvAction((View)this, (ColumnViewer)this.viewer, true);
        this.actionCreateSnmpDci = new CreateSnmpDci((ObjectView)this);
    }

    private void selectInTree() {
        MibObject o;
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length == 1 && (o = MibCache.findObject((String)selection[0].getText(0), (boolean)false)) != null) {
            this.mibBrowser.setSelection(o);
        }
    }

    private void copyColumnToClipboard(int column) {
        TableItem[] selection = this.viewer.getTable().getSelection();
        if (selection.length > 0) {
            String newLine = WidgetHelper.getNewLineCharacters();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < selection.length; ++i) {
                if (i > 0) {
                    sb.append(newLine);
                }
                sb.append(selection[i].getText(column));
            }
            WidgetHelper.copyToClipboard((String)sb.toString());
        }
    }

    private void createTreePopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.mibBrowser.getTreeControl());
        this.mibBrowser.getTreeControl().setMenu(menu);
    }

    protected void fillTreeContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionWalk);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyObjectName);
        manager.add((IContributionItem)new Separator());
    }

    private void createResultsPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu((Control)this.viewer.getTable());
        this.viewer.getTable().setMenu(menu);
    }

    protected void fillResultsContextMenu(IMenuManager manager) {
        if (this.viewer.getSelection().isEmpty()) {
            return;
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyName);
        manager.add((IAction)this.actionCopySymbolicName);
        manager.add((IAction)this.actionCopyType);
        manager.add((IAction)this.actionCopyValue);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCreateSnmpDci);
    }

    private void setupViewerColumns() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("OID"));
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText("OID as text");
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("Type"));
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        tc.setText(i18n.tr("Value"));
        tc.setWidth(300);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (String)ID);
    }

    protected void onObjectChange(AbstractObject object) {
        this.currentNode = (AbstractNode)object;
        this.actionWalk.setEnabled(object != null && !this.walkActive);
    }

    private void doWalk() {
        if (this.walkActive || this.currentNode == null) {
            return;
        }
        MibObject object = this.mibBrowser.getSelection();
        if (object == null) {
            return;
        }
        this.walkActive = true;
        this.actionWalk.setEnabled(false);
        this.viewer.setInput((Object)new SnmpValue[0]);
        this.walkData.clear();
        15 job = new /* Unavailable Anonymous Inner Class!! */;
        job.setUser(false);
        job.start();
    }

    public void onSnmpWalkData(List<SnmpValue> data) {
        this.viewer.getControl().getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void dispose() {
        this.headerFont.dispose();
        super.dispose();
    }

    public boolean isValidForContext(Object context) {
        return context != null && context instanceof Node && ((Node)context).hasSnmpAgent();
    }
}

