/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconsole.views;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.TerminalViewControlFactory;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.server.ServerConsoleListener;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconsole.Activator;
import org.netxms.ui.eclipse.serverconsole.Messages;
import org.netxms.ui.eclipse.serverconsole.views.helpers.ServerConsoleTerminalConnector;
import org.netxms.ui.eclipse.serverconsole.views.helpers.TerminalReader;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerConsole
extends ViewPart
implements ITerminalListener {
    public static final String ID = "org.netxms.ui.eclipse.serverconsole.views.ServerConsole";
    private ITerminalViewControl terminal;
    private ServerConsoleTerminalConnector connector;
    private NXCSession session;
    private boolean scrollLock = false;
    private Action actionClear;
    private Action actionScrollLock;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.terminal = TerminalViewControlFactory.makeControl((ITerminalListener)this, (Composite)parent, null, (boolean)false);
        this.connector = new ServerConsoleTerminalConnector();
        this.terminal.setConnector((ITerminalConnector)this.connector);
        this.terminal.connectTerminal();
        this.terminal.setInvertedColors(true);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        if (this.session.isServerConsoleConnected()) {
            this.setConnected();
        } else {
            this.connectToServer();
        }
    }

    private void connectToServer() {
        Messages.get();
        new ConsoleJob(Messages.ServerConsole_OpenServerConsole, null, "org.netxms.ui.eclipse.serverconsole", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NXCSession session = ConsoleSharedData.getSession();
                session.openConsole();
                ServerConsole.this.setConnected();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ServerConsole_CannotOpen;
            }

            protected void jobFailureHandler() {
                ServerConsole.this.writeToTerminal("\r\n\u001b[31;1m*** DISCONNECTED ***\u001b[0m");
                ServerConsole.this.terminal.disconnectTerminal();
            }
        }.start();
    }

    private void setConnected() {
        this.writeToTerminal("\u001b[1mNetXMS Server Remote Console V" + this.session.getServerVersion() + " Ready\r\n\r\n\u001b[0m");
        this.session.addConsoleListener(new ServerConsoleListener(){

            public void onConsoleOutput(String text) {
                ServerConsole.this.writeToTerminal(text.replaceAll("\n", "\r\n"));
            }
        });
        Thread inputReader = new Thread(){

            @Override
            public void run() {
                try {
                    String command;
                    TerminalReader in = new TerminalReader(new InputStreamReader(ServerConsole.this.connector.getInputStream()), ServerConsole.this.connector.getRemoteToTerminalOutputStream());
                    while ((command = in.readLine().trim()).isEmpty() || !ServerConsole.this.session.processConsoleCommand(command)) {
                    }
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            (this).ServerConsole.this.terminal.disconnectTerminal();
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)ServerConsole.this);
                        }
                    });
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        inputReader.start();
    }

    private void writeToTerminal(String text) {
        try {
            this.connector.getRemoteToTerminalOutputStream().write(text.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setFocus() {
        this.terminal.setFocus();
    }

    private void createActions() {
        Messages.get();
        this.actionClear = new Action(Messages.ServerConsole_ClearTerminal, SharedIcons.CLEAR_LOG){

            public void run() {
                ServerConsole.this.terminal.clearTerminal();
                ServerConsole.this.writeToTerminal("\u001b[33mnetxmsd:\u001b[0m ");
            }
        };
        Messages.get();
        this.actionScrollLock = new Action(Messages.ServerConsole_ScrollLock, 2){

            public void run() {
                ServerConsole.this.scrollLock = !ServerConsole.this.scrollLock;
                ServerConsole.this.terminal.setScrollLock(ServerConsole.this.scrollLock);
                ServerConsole.this.actionScrollLock.setChecked(ServerConsole.this.scrollLock);
            }
        };
        this.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actionScrollLock.setChecked(this.scrollLock);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                ServerConsole.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.terminal.getControl());
        this.terminal.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    public void setState(TerminalState state) {
    }

    public void setTerminalTitle(String title) {
    }

    public void dispose() {
        this.terminal.disposeTerminal();
        super.dispose();
    }
}

