/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.widgets;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.part.ViewPart;
import org.netxms.ui.eclipse.objects.ObjectContext;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.widgets.AbstractObjectToolExecutor;

public class LocalCommandExecutor
extends AbstractObjectToolExecutor {
    private Process process;
    private boolean processRunning = false;
    private String command;
    private Object mutex = new Object();

    public LocalCommandExecutor(Composite resultArea, ViewPart view, ObjectContext objectContext, AbstractObjectToolExecutor.ActionSet actionSet, String command) {
        super(resultArea, view, objectContext, actionSet);
        this.command = command;
        this.addDisposeListener(new DisposeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void widgetDisposed(DisposeEvent e) {
                Object object = LocalCommandExecutor.this.mutex;
                synchronized (object) {
                    if (LocalCommandExecutor.this.processRunning) {
                        LocalCommandExecutor.this.process.destroy();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeInternal() throws Exception {
        block22: {
            Object object = this.mutex;
            synchronized (object) {
                if (this.processRunning) {
                    this.process.destroy();
                    try {
                        this.mutex.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.processRunning = true;
            }
            this.process = Runtime.getRuntime().exec(this.command);
            InputStream in = this.process.getInputStream();
            try {
                try {
                    int bytes;
                    byte[] data = new byte[16384];
                    boolean isWindows = Platform.getOS().equals("win32");
                    while ((bytes = in.read(data)) != -1) {
                        String s = new String(Arrays.copyOf(data, bytes));
                        if (isWindows) {
                            this.out.write(s.replace("\r\r\n", " \r\n"));
                            continue;
                        }
                        this.out.write(s);
                    }
                    Messages.get();
                    this.out.write(Messages.LocalCommandResults_Terminated);
                }
                catch (IOException e) {
                    Activator.logError("Exception while running local command", e);
                    in.close();
                    Object object2 = this.mutex;
                    synchronized (object2) {
                        this.processRunning = false;
                        this.process = null;
                        this.mutex.notifyAll();
                        break block22;
                    }
                }
            }
            catch (Throwable throwable) {
                in.close();
                Object object3 = this.mutex;
                synchronized (object3) {
                    this.processRunning = false;
                    this.process = null;
                    this.mutex.notifyAll();
                }
                throw throwable;
            }
            in.close();
            Object object4 = this.mutex;
            synchronized (object4) {
                this.processRunning = false;
                this.process = null;
                this.mutex.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void terminate() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.processRunning) {
                this.process.destroy();
            }
        }
    }

    @Override
    protected boolean isTerminateSupported() {
        return true;
    }
}

