/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.dialogs;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.users.TwoFactorAuthenticationMethod;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.AbstractMethodBindingConfigurator;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.CustomMethodBindingConfigurator;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.MessageMethodBindingConfigurator;
import org.netxms.ui.eclipse.usermanager.dialogs.helpers.TOTPMethodBindingConfigurator;

public class TwoFactorAuthMethodEditDialog
extends Dialog {
    private String name;
    private Map<String, String> configuration;
    private Map<String, TwoFactorAuthenticationMethod> availableMethods = new HashMap<String, TwoFactorAuthenticationMethod>();
    private Combo methodSelector;
    private Composite configurationArea;
    private AbstractMethodBindingConfigurator methodConfigurator;

    public TwoFactorAuthMethodEditDialog(Shell parentShell, String name, Map<String, String> configuration) {
        super(parentShell);
        this.name = name;
        this.configuration = configuration != null ? new HashMap<String, String>(configuration) : null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.name != null ? "Edit Two-Factor Authentication Method" : "Add Two-Factor Authentication Method");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.methodSelector = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)"Method", (Object)new GridData(4, 0x1000000, true, false));
        this.methodSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = TwoFactorAuthMethodEditDialog.this.methodSelector.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                String methodName = TwoFactorAuthMethodEditDialog.this.methodSelector.getItem(index);
                TwoFactorAuthenticationMethod method = TwoFactorAuthMethodEditDialog.this.availableMethods.get(methodName);
                TwoFactorAuthMethodEditDialog.this.createConfigurator(method.getDriver());
            }
        });
        this.readMethodList();
        if (this.name != null) {
            this.methodSelector.setEnabled(false);
        }
        this.configurationArea = new Composite(dialogArea, 0);
        this.configurationArea.setLayout((Layout)new FillLayout());
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 600;
        this.configurationArea.setLayoutData((Object)gd);
        return dialogArea;
    }

    private void readMethodList() {
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Get list of available 2FA methods", null, "org.netxms.ui.eclipse.usermanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List methods = session.get2FAMethods();
                Collections.sort(methods, new Comparator<TwoFactorAuthenticationMethod>(){

                    @Override
                    public int compare(TwoFactorAuthenticationMethod m1, TwoFactorAuthenticationMethod m2) {
                        return m1.getName().compareToIgnoreCase(m2.getName());
                    }
                });
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (TwoFactorAuthenticationMethod m : methods) {
                            (this).TwoFactorAuthMethodEditDialog.this.availableMethods.put(m.getName(), m);
                            (this).TwoFactorAuthMethodEditDialog.this.methodSelector.add(m.getName());
                            if (!m.getName().equals((this).TwoFactorAuthMethodEditDialog.this.name)) continue;
                            (this).TwoFactorAuthMethodEditDialog.this.methodSelector.select((this).TwoFactorAuthMethodEditDialog.this.methodSelector.getItemCount() - 1);
                            TwoFactorAuthMethodEditDialog.this.createConfigurator(m.getDriver());
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get list of available 2FA methods";
            }
        }.start();
    }

    private void createConfigurator(String driver) {
        if (this.methodConfigurator != null) {
            this.methodConfigurator.dispose();
        }
        this.methodConfigurator = driver.equals("TOTP") ? new TOTPMethodBindingConfigurator(this.configurationArea) : (driver.equals("Message") ? new MessageMethodBindingConfigurator(this.configurationArea) : new CustomMethodBindingConfigurator(this.configurationArea));
        this.getShell().pack();
        if (this.configuration != null) {
            this.methodConfigurator.setConfiguration(this.configuration);
        }
    }

    protected void okPressed() {
        int index = this.methodSelector.getSelectionIndex();
        if (index == -1) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Error", (String)"Authentication method not selected!");
            return;
        }
        this.name = this.methodSelector.getItem(index);
        this.configuration = this.methodConfigurator != null ? this.methodConfigurator.getConfiguration() : new HashMap(0);
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getConfiguration() {
        return this.configuration;
    }
}

