/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.objecttabs;

import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.TimePeriod;
import org.netxms.client.constants.DataType;
import org.netxms.client.constants.TimeFrameType;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.BusinessService;
import org.netxms.client.objects.BusinessServicePrototype;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.objecttabs.ObjectTab;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.slm.Activator;
import org.netxms.ui.eclipse.slm.objecttabs.helpers.BusinessServiceTicketComparator;
import org.netxms.ui.eclipse.slm.objecttabs.helpers.BusinessServiceTicketLabelProvider;
import org.netxms.ui.eclipse.tools.DateBuilder;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DateTimeSelector;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class BusinessServiceAvailability
extends ObjectTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_SERVICE_ID = 1;
    public static final int COLUMN_CHECK_ID = 2;
    public static final int COLUMN_CHECK_DESCRIPTION = 3;
    public static final int COLUMN_CREATION_TIME = 4;
    public static final int COLUMN_TERMINATION_TIME = 5;
    public static final int COLUMN_REASON = 6;
    private static final String CONFIG_PREFIX = "BusinessServiceAvailability";
    private NXCSession session;
    private DateTimeSelector startDateSelector;
    private DateTimeSelector endDateSelector;
    private Button buttonQuery;
    private Chart chart;
    private SortableTableViewer ticketViewer;

    protected void createTabContent(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite queryGroup = new Composite(parent, 0);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        queryGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        queryGroup.setLayout((Layout)layout);
        Composite timeSelectorGroup = new Composite(queryGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 30;
        timeSelectorGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        timeSelectorGroup.setLayoutData((Object)gd);
        this.startDateSelector = new DateTimeSelector(timeSelectorGroup, 0);
        Label label = new Label(timeSelectorGroup, 0x1000000);
        label.setText("\u2015");
        gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        gd.verticalAlignment = 0x1000000;
        label.setLayoutData((Object)gd);
        this.endDateSelector = new DateTimeSelector(timeSelectorGroup, 0);
        Composite buttonGroup = new Composite(queryGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonGroup.setLayoutData((Object)gd);
        this.createQuickSetButton(buttonGroup, "Today", new DateBuilder().setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, "Yesterday", new DateBuilder().setMidnight().add(5, -1).create(), new DateBuilder().setMidnight().add(13, -1).create());
        this.createQuickSetButton(buttonGroup, "This month", new DateBuilder().set(5, 1).setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, "Last month", new DateBuilder().add(2, -1).set(5, 1).setMidnight().create(), new DateBuilder().add(2, -1).setLastDayOfMonth().setMidnight().add(13, -1).create());
        this.createQuickSetButton(buttonGroup, "This year", new DateBuilder().set(6, 1).setMidnight().create(), null);
        this.createQuickSetButton(buttonGroup, "Last year", new DateBuilder().add(1, -1).set(6, 1).setMidnight().create(), new DateBuilder().set(6, 1).setMidnight().add(13, -1).create());
        this.buttonQuery = new Button(queryGroup, 8);
        this.buttonQuery.setText("Query");
        this.buttonQuery.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                BusinessServiceAvailability.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
        gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalAlignment = 131072;
        this.buttonQuery.setLayoutData((Object)gd);
        Label separator = new Label(parent, 258);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        ChartConfiguration chartConfiguration = new ChartConfiguration();
        chartConfiguration.setLegendVisible(true);
        chartConfiguration.setLegendPosition(2);
        chartConfiguration.setTranslucent(false);
        this.chart = new Chart(parent, 0, ChartType.PIE, chartConfiguration);
        this.chart.setBackground(this.chart.getDisplay().getSystemColor(22));
        this.chart.addParameter(new GraphItem(DataType.FLOAT, "Uptime", "Uptime", "%s"));
        this.chart.addParameter(new GraphItem(DataType.FLOAT, "Downtime", "Downtime", "%s"));
        this.chart.setPaletteEntry(0, new ChartColor(127, 154, 72));
        this.chart.setPaletteEntry(1, new ChartColor(158, 65, 62));
        this.chart.rebuild();
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.chart.setLayoutData((Object)gd);
        separator = new Label(parent, 258);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gd);
        String[] names = new String[]{"ID", "Service", "Check ID", "Description", "Created", "Closed", "Reason"};
        int[] widths = new int[]{70, 200, 70, 300, 150, 150, 300};
        this.ticketViewer = new SortableTableViewer(parent, names, widths, 0, 1024, -1);
        this.ticketViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ticketViewer.setLabelProvider((IBaseLabelProvider)new BusinessServiceTicketLabelProvider());
        this.ticketViewer.setComparator((ViewerComparator)new BusinessServiceTicketComparator());
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        WidgetHelper.restoreColumnSettings((Table)this.ticketViewer.getTable(), (IDialogSettings)settings, (String)CONFIG_PREFIX);
        this.ticketViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)BusinessServiceAvailability.this.ticketViewer.getTable(), (IDialogSettings)settings, (String)BusinessServiceAvailability.CONFIG_PREFIX);
            }
        });
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        this.ticketViewer.getTable().setLayoutData((Object)gd);
    }

    private void createQuickSetButton(Composite parent, String name, final Date startTime, final Date endTime) {
        Button button = new Button(parent, 8);
        button.setText(name);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusinessServiceAvailability.this.startDateSelector.setValue(startTime != null ? startTime : new Date());
                BusinessServiceAvailability.this.endDateSelector.setValue(endTime != null ? endTime : new Date());
                BusinessServiceAvailability.this.refresh();
            }
        });
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        button.setLayoutData((Object)gd);
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof BusinessService && !(object instanceof BusinessServicePrototype);
    }

    public void objectChanged(AbstractObject object) {
        this.ticketViewer.setInput((Object)new Object[0]);
        this.chart.clearParameters();
        this.chart.refresh();
    }

    public void refresh() {
        final TimePeriod timePeriod = new TimePeriod(TimeFrameType.FIXED, 0, null, this.startDateSelector.getValue(), this.endDateSelector.getValue());
        ConsoleJob availabilityJob = new ConsoleJob("Get business ervice availability", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final double availability = BusinessServiceAvailability.this.session.getBusinessServiceAvailablity(BusinessServiceAvailability.this.getObject().getObjectId(), timePeriod);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).BusinessServiceAvailability.this.chart.updateParameter(0, availability, false);
                        (this).BusinessServiceAvailability.this.chart.updateParameter(1, 100.0 - availability, true);
                        (this).BusinessServiceAvailability.this.chart.refresh();
                        (this).BusinessServiceAvailability.this.chart.clearErrors();
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get availability for business service %s", BusinessServiceAvailability.this.getObject().getObjectName());
            }
        };
        availabilityJob.setUser(false);
        availabilityJob.start();
        ConsoleJob ticketJob = new ConsoleJob("Get business service tickets", (IWorkbenchPart)this.getViewPart(), "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List tickets = BusinessServiceAvailability.this.session.getBusinessServiceTickets(BusinessServiceAvailability.this.getObject().getObjectId(), timePeriod);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).BusinessServiceAvailability.this.ticketViewer.setInput((Object)tickets);
                    }
                });
            }

            protected String getErrorMessage() {
                return String.format("Cannot get tickets for business service %s", BusinessServiceAvailability.this.getObject().getObjectName());
            }
        };
        ticketJob.setUser(false);
        ticketJob.start();
    }
}

