/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.dashboard.ElementCreationHandler;
import org.netxms.ui.eclipse.dashboard.Messages;

public class ElementCreationMenuManager
extends MenuManager {
    private ElementCreationHandler handler;

    public ElementCreationMenuManager(ElementCreationHandler handler) {
        this.handler = handler;
        this.fillMenu();
    }

    public ElementCreationMenuManager(String name, ElementCreationHandler handler) {
        super(name);
        this.handler = handler;
        this.fillMenu();
    }

    private void fillMenu() {
        MenuManager chartsMenu = new MenuManager("&Charts");
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_LineChart, 1);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_BarChart, 2);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_PieChart, 3);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_GaugeChart, 13);
        chartsMenu.add((IContributionItem)new Separator());
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_BarChartForTable, 15);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_PieChartForTable, 16);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_TubeChartForTable, 17);
        chartsMenu.add((IContributionItem)new Separator());
        this.addTypeToSelectionMenu(chartsMenu, "Scripted bar chart", 30);
        this.addTypeToSelectionMenu(chartsMenu, "Scripted pie chart", 31);
        chartsMenu.add((IContributionItem)new Separator());
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_StatusChart, 5);
        Messages.get();
        this.addTypeToSelectionMenu(chartsMenu, Messages.AddDashboardElementDlg_AvailabilityChart, 12);
        this.add((IContributionItem)chartsMenu);
        MenuManager tablesMenu = new MenuManager("&Tables");
        Messages.get();
        this.addTypeToSelectionMenu(tablesMenu, Messages.AddDashboardElementDlg_AlarmViewer, 11);
        Messages.get();
        this.addTypeToSelectionMenu(tablesMenu, Messages.AddDashboardElementDlg_TableValue, 19);
        Messages.get();
        this.addTypeToSelectionMenu(tablesMenu, Messages.AddDashboardElementDlg_DciSummaryTable, 21);
        this.addTypeToSelectionMenu(tablesMenu, "Object query", 28);
        this.add((IContributionItem)tablesMenu);
        MenuManager mapsMenu = new MenuManager("&Maps");
        Messages.get();
        this.addTypeToSelectionMenu(mapsMenu, Messages.AddDashboardElementDlg_NetworkMap, 8);
        this.addTypeToSelectionMenu(mapsMenu, "Service components map", 25);
        Messages.get();
        this.addTypeToSelectionMenu(mapsMenu, Messages.AddDashboardElementDlg_StatusMap, 20);
        Messages.get();
        this.addTypeToSelectionMenu(mapsMenu, Messages.AddDashboardElementDlg_GeoMap, 10);
        this.add((IContributionItem)mapsMenu);
        MenuManager monitorsMenu = new MenuManager("M&onitors");
        this.addTypeToSelectionMenu(monitorsMenu, "Event monitor", 24);
        this.addTypeToSelectionMenu(monitorsMenu, "SNMP trap monitor", 23);
        this.addTypeToSelectionMenu(monitorsMenu, "Syslog monitor", 22);
        this.add((IContributionItem)monitorsMenu);
        MenuManager othersMenu = new MenuManager("&Others");
        Messages.get();
        this.addTypeToSelectionMenu(othersMenu, Messages.AddDashboardElementDlg_StatusIndicator, 6);
        this.addTypeToSelectionMenu(othersMenu, "Port view", 29);
        this.addTypeToSelectionMenu(othersMenu, "Rack diagram", 26);
        this.addTypeToSelectionMenu(othersMenu, "Object Tools", 27);
        Messages.get();
        this.addTypeToSelectionMenu(othersMenu, Messages.AddDashboardElementDlg_CustomWidget, 9);
        this.add((IContributionItem)othersMenu);
        this.add((IContributionItem)new Separator());
        Messages.get();
        this.addTypeToSelectionMenu(this, Messages.AddDashboardElementDlg_Dashboard, 7);
        Messages.get();
        this.addTypeToSelectionMenu(this, Messages.AddDashboardElementDlg_WebPage, 14);
        this.add((IContributionItem)new Separator());
        Messages.get();
        this.addTypeToSelectionMenu(this, Messages.AddDashboardElementDlg_Label, 0);
        Messages.get();
        this.addTypeToSelectionMenu(this, Messages.AddDashboardElementDlg_Separator, 18);
    }

    private void addTypeToSelectionMenu(MenuManager manager, String name, final int type) {
        manager.add((IAction)new Action(name){

            public void run() {
                ElementCreationMenuManager.this.handler.elementCreated(new DashboardElement(type, ElementCreationMenuManager.getDefaultElementConfig(type)));
            }
        });
    }

    private static String getDefaultElementConfig(int type) {
        switch (type) {
            case 2: 
            case 3: 
            case 4: 
            case 30: 
            case 31: {
                return "<element>\n\t<showIn3D>true</showIn3D>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
            }
            case 1: {
                return "<element>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
            }
            case 13: {
                return "<element>\n\t<maxValue>100</maxValue>\n\t<yellowZone>70</yellowZone>\n\t<redZone>90</redZone>\n\t<dciList length=\"0\">\n\t</dciList>\n</element>";
            }
            case 12: {
                return "<element>\n\t<objectId>9</objectId>\n\t<showIn3D>true</showIn3D>\n</element>";
            }
            case 15: 
            case 16: 
            case 17: {
                return "<element>\n\t<showIn3D>true</showIn3D>\n\t<nodeId>0</nodeId>\n\t<dciId>0</dciId>\n\t<dataColumn>DATA</dataColumn>\n</element>";
            }
            case 0: {
                return "<element>\n\t<title>Label</title>\n</element>";
            }
            case 6: 
            case 7: 
            case 11: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                return "<element>\n\t<objectId>0</objectId>\n</element>";
            }
            case 8: 
            case 25: {
                return "<element>\n\t<objectId>0</objectId>\n\t<title></title>\n</element>";
            }
            case 10: {
                return "<element>\n\t<latitude>0</latitude>\n\t<longitude>0</longitude>\n\t<zoom>8</zoom>\t<title></title>\n</element>";
            }
            case 14: {
                return "<element>\n\t<url>http://</url>\n\t<title></title>\n</element>";
            }
            case 19: {
                return "<element>\n\t<objectId>0</objectId>\n\t<dciId>0</dciId>\n\t<title></title>\n</element>";
            }
            case 21: {
                return "<element>\n\t<baseObjectId>0</baseObjectId>\n\t<tableId>0</tableId>\n</element>";
            }
        }
        return "<element>\n</element>";
    }
}

