/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.propertypages.helpers;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RackView {
    FULL(0),
    FRONT(1),
    BACK(2);

    private static final Logger logger;
    private static final Map<Integer, RackView> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(RackView.class);
        lookupTable = new HashMap<Integer, RackView>();
        RackView[] rackViewArray = RackView.values();
        int n = rackViewArray.length;
        int n2 = 0;
        while (n2 < n) {
            RackView element = rackViewArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private RackView(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static RackView getByValue(int value) {
        RackView element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FULL;
        }
        return element;
    }
}

