/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenExecutionContext;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.WorkingSets;
import org.eclipse.m2e.core.ui.internal.util.Util;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelectionUtil {
    private static final Logger log = LoggerFactory.getLogger(SelectionUtil.class);
    public static final int UNSUPPORTED = 0;
    public static final int PROJECT_WITH_NATURE = 1;
    public static final int PROJECT_WITHOUT_NATURE = 2;
    public static final int POM_FILE = 4;
    public static final int JAR_FILE = 8;
    public static final int WORKING_SET = 16;

    public static int getSelectionType(IStructuredSelection selection) {
        int type = 0;
        if (selection != null) {
            for (Object name : selection) {
                int elementType = SelectionUtil.getElementType(name);
                if (elementType == 0) {
                    return 0;
                }
                type |= elementType;
            }
        }
        return type;
    }

    public static int getElementType(Object element) {
        IFile file;
        IProject project = SelectionUtil.getType(element, IProject.class);
        if (project != null) {
            try {
                if (project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
                    return 1;
                }
                return 2;
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if ((file = SelectionUtil.getType(element, IFile.class)) != null && "pom.xml".equals(file.getFullPath().lastSegment())) {
            return 4;
        }
        ArtifactKey artifactKey = SelectionUtil.getType(element, ArtifactKey.class);
        if (artifactKey != null) {
            return 8;
        }
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return 16;
        }
        return 0;
    }

    public static <T> T getType(Object element, Class<T> type) {
        Object adapter;
        if (element == null) {
            return null;
        }
        if (type.isInstance(element)) {
            return type.cast(element);
        }
        if (element instanceof IAdaptable && (adapter = ((IAdaptable)element).getAdapter(type)) != null) {
            return (T)adapter;
        }
        return (T)Platform.getAdapterManager().getAdapter(element, type);
    }

    public static IPath getSelectedLocation(IStructuredSelection selection) {
        Object element = selection == null ? null : selection.getFirstElement();
        IPath path = SelectionUtil.getType(element, IPath.class);
        if (path != null) {
            return path;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return resource.getLocation();
        }
        return null;
    }

    public static IWorkingSet getSelectedWorkingSet(IStructuredSelection selection) {
        Object element;
        Object object = element = selection == null ? null : selection.getFirstElement();
        if (element == null) {
            return null;
        }
        IWorkingSet workingSet = SelectionUtil.getType(element, IWorkingSet.class);
        if (workingSet != null) {
            return workingSet;
        }
        IResource resource = SelectionUtil.getType(element, IResource.class);
        if (resource != null) {
            return WorkingSets.getAssignedWorkingSet((IResource)resource.getProject());
        }
        return null;
    }

    public static ArtifactKey getArtifactKey(Object element) {
        if (element instanceof Artifact) {
            return new ArtifactKey((Artifact)element);
        }
        if (element instanceof DependencyNode) {
            org.eclipse.aether.artifact.Artifact artifact = ((DependencyNode)element).getDependency().getArtifact();
            return new ArtifactKey(artifact);
        }
        return SelectionUtil.getType(element, ArtifactKey.class);
    }

    public static MavenProject getMavenProject(IEditorInput editorInput, IProgressMonitor monitor) throws CoreException {
        if (editorInput instanceof IFileEditorInput) {
            IFile pomFile = ((IFileEditorInput)editorInput).getFile();
            IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
            IMavenProjectFacade facade = projectManager.create(pomFile, true, monitor);
            if (facade != null) {
                return facade.getMavenProject(monitor);
            }
        } else {
            if (editorInput instanceof IStorageEditorInput) {
                IStorageEditorInput storageInput = (IStorageEditorInput)editorInput;
                IStorage storage = storageInput.getStorage();
                IPath path = storage.getFullPath();
                if (path == null || !new File(path.toOSString()).exists()) {
                    File tempPomFile = null;
                    try {
                        MavenProject mavenProject;
                        block22: {
                            Throwable throwable = null;
                            Object var7_12 = null;
                            InputStream is = storage.getContents();
                            try {
                                tempPomFile = File.createTempFile("maven-pom", ".pom");
                                Files.copy(is, tempPomFile.toPath(), new CopyOption[0]);
                                mavenProject = SelectionUtil.readMavenProject(tempPomFile, monitor);
                                if (is == null) break block22;
                            }
                            catch (Throwable throwable2) {
                                try {
                                    try {
                                        if (is != null) {
                                            is.close();
                                        }
                                        throw throwable2;
                                    }
                                    catch (Throwable throwable3) {
                                        if (throwable == null) {
                                            throwable = throwable3;
                                        } else if (throwable != throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException ex) {
                                    log.error("Can't close stream", (Throwable)ex);
                                }
                            }
                            is.close();
                        }
                        return mavenProject;
                    }
                    finally {
                        if (tempPomFile != null) {
                            tempPomFile.delete();
                        }
                    }
                }
                return SelectionUtil.readMavenProject(path.toFile(), monitor);
            }
            if (editorInput.getClass().getName().endsWith("FileStoreEditorInput")) {
                return SelectionUtil.readMavenProject(new File(Util.proxy(editorInput, Util.FileStoreEditorInputStub.class).getURI().getPath()), monitor);
            }
        }
        return null;
    }

    private static MavenProject readMavenProject(File pomFile, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        IMaven maven = MavenPlugin.getMaven();
        IMavenExecutionContext context = maven.createExecutionContext();
        MavenExecutionRequest request = context.getExecutionRequest();
        request.setOffline(false);
        request.setUpdateSnapshots(false);
        request.setRecursive(false);
        MavenExecutionResult result = (MavenExecutionResult)context.execute((context1, monitor1) -> maven.readMavenProject(pomFile, context1.newProjectBuildingRequest()), monitor);
        MavenProject project = result.getProject();
        if (project != null) {
            return project;
        }
        if (result.hasExceptions()) {
            ArrayList<Status> statuses = new ArrayList<Status>();
            List exceptions = result.getExceptions();
            for (Throwable e : exceptions) {
                statuses.add(new Status(4, "org.eclipse.m2e.core", -1, e.getMessage(), e));
            }
            throw new CoreException((IStatus)new MultiStatus("org.eclipse.m2e.core", 4, statuses.toArray(new IStatus[statuses.size()]), Messages.SelectionUtil_error_cannot_read, null));
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.SelectionUtil_error_cannot_read, null));
    }

    public static IFile getPomFileFromPomEditorOrViewSelection(ISelection selection) {
        IFileEditorInput fileInput;
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        IWorkbenchWindow window;
        IFile file = null;
        if (selection instanceof IStructuredSelection) {
            Object o = ((IStructuredSelection)selection).iterator().next();
            if (o instanceof IProject) {
                file = ((IProject)o).getFile("pom.xml");
            } else if (o instanceof IFile) {
                file = (IFile)o;
            }
            if (file != null) {
                return file;
            }
        }
        if ((window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput && "pom.xml".equals((file = (fileInput = (IFileEditorInput)input).getFile()).getName())) {
            return file;
        }
        return null;
    }

    public static IProject[] getProjects(ISelection selection, boolean includeAll) {
        ArrayList<IProject> projectList = new ArrayList<IProject>();
        if (selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                if (o instanceof IProject) {
                    SelectionUtil.safeAdd((IProject)o, projectList);
                    continue;
                }
                if (o instanceof IWorkingSet) {
                    IWorkingSet workingSet = (IWorkingSet)o;
                    IAdaptable[] iAdaptableArray = workingSet.getElements();
                    int n = iAdaptableArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IAdaptable adaptable = iAdaptableArray[n2];
                        IProject project = (IProject)adaptable.getAdapter(IProject.class);
                        SelectionUtil.safeAdd(project, projectList);
                        ++n2;
                    }
                    continue;
                }
                if (o instanceof IResource) {
                    SelectionUtil.safeAdd(((IResource)o).getProject(), projectList);
                    continue;
                }
                if (!(o instanceof IAdaptable)) continue;
                IAdaptable adaptable = (IAdaptable)o;
                IProject project = (IProject)adaptable.getAdapter(IProject.class);
                SelectionUtil.safeAdd(project, projectList);
            }
        }
        if (projectList.isEmpty() && includeAll) {
            return ResourcesPlugin.getWorkspace().getRoot().getProjects();
        }
        return projectList.toArray(new IProject[projectList.size()]);
    }

    private static void safeAdd(IProject project, List<IProject> projectList) {
        try {
            if (project != null && project.isAccessible() && project.hasNature("org.eclipse.m2e.core.maven2Nature") && !projectList.contains(project)) {
                projectList.add(project);
            }
        }
        catch (CoreException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
        }
    }
}

