/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapObjectDisplayMode;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ColorConverter;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MapOptions
extends PropertyPage {
    private NetworkMap object;
    private Button checkShowStatusIcon;
    private Button checkShowStatusFrame;
    private Button checkShowStatusBkgnd;
    private Button checkShowLinkDirection;
    private Button checkUseL1Topology;
    private Combo objectDisplayMode;
    private Combo routingAlgorithm;
    private Button radioColorDefault;
    private Button radioColorCustom;
    private ColorSelector linkColor;
    private Button checkIncludeEndNodes;
    private Button checkCustomRadius;
    private Spinner topologyRadius;
    private Button checkCalculateStatus;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.object = (NetworkMap)this.getElement().getAdapter(NetworkMap.class);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group objectDisplayGroup = new Group(dialogArea, 0);
        Messages.get();
        objectDisplayGroup.setText(Messages.MapOptions_DefaultDispOptions);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        objectDisplayGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        objectDisplayGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.objectDisplayMode = WidgetHelper.createLabeledCombo((Composite)objectDisplayGroup, (int)8, (String)Messages.MapOptions_DisplayObjectsAs, (Object)gd);
        Messages.get();
        this.objectDisplayMode.add(Messages.MapOptions_Icons);
        Messages.get();
        this.objectDisplayMode.add(Messages.MapOptions_SmallLabels);
        Messages.get();
        this.objectDisplayMode.add(Messages.MapOptions_LargeLabels);
        Messages.get();
        this.objectDisplayMode.add(Messages.MapOptions_StatusIcons);
        this.objectDisplayMode.add("Floor plan");
        this.objectDisplayMode.select(this.object.getObjectDisplayMode().getValue());
        this.checkShowStatusIcon = new Button((Composite)objectDisplayGroup, 32);
        Messages.get();
        this.checkShowStatusIcon.setText(Messages.MapOptions_ShowStatusIcon);
        this.checkShowStatusIcon.setSelection((this.object.getFlags() & 1) != 0);
        this.checkShowStatusFrame = new Button((Composite)objectDisplayGroup, 32);
        Messages.get();
        this.checkShowStatusFrame.setText(Messages.MapOptions_ShowStatusFrame);
        this.checkShowStatusFrame.setSelection((this.object.getFlags() & 2) != 0);
        this.checkShowStatusBkgnd = new Button((Composite)objectDisplayGroup, 32);
        Messages.get();
        this.checkShowStatusBkgnd.setText(Messages.MapOptions_ShowStatusBkgnd);
        this.checkShowStatusBkgnd.setSelection((this.object.getFlags() & 4) != 0);
        this.checkShowLinkDirection = new Button((Composite)objectDisplayGroup, 32);
        this.checkShowLinkDirection.setText("Show link direction");
        this.checkShowLinkDirection.setSelection((this.object.getFlags() & 0x40) != 0);
        Group linkGroup = new Group(dialogArea, 0);
        Messages.get();
        linkGroup.setText(Messages.MapOptions_DefaultConnOptions);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        linkGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        linkGroup.setLayout((Layout)layout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        Messages.get();
        this.routingAlgorithm = WidgetHelper.createLabeledCombo((Composite)linkGroup, (int)8, (String)Messages.MapOptions_RoutingAlg, (Object)gd);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapOptions_Direct);
        Messages.get();
        this.routingAlgorithm.add(Messages.MapOptions_Manhattan);
        this.routingAlgorithm.select(this.object.getDefaultLinkRouting() - 1);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MapOptions.this.linkColor.setEnabled(MapOptions.this.radioColorCustom.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        };
        this.radioColorDefault = new Button((Composite)linkGroup, 16);
        Messages.get();
        this.radioColorDefault.setText(Messages.MapOptions_DefColor);
        this.radioColorDefault.setSelection(this.object.getDefaultLinkColor() < 0);
        this.radioColorDefault.addSelectionListener(listener);
        gd = new GridData();
        gd.verticalIndent = 8;
        this.radioColorDefault.setLayoutData((Object)gd);
        this.radioColorCustom = new Button((Composite)linkGroup, 16);
        Messages.get();
        this.radioColorCustom.setText(Messages.MapOptions_CustColor);
        this.radioColorCustom.setSelection(this.object.getDefaultLinkColor() >= 0);
        this.radioColorCustom.addSelectionListener(listener);
        this.linkColor = new ColorSelector((Composite)linkGroup);
        this.linkColor.setColorValue(ColorConverter.rgbFromInt((int)this.object.getDefaultLinkColor()));
        this.linkColor.setEnabled(this.object.getDefaultLinkColor() >= 0);
        gd = new GridData();
        gd.horizontalIndent = 20;
        this.linkColor.getButton().setLayoutData((Object)gd);
        if (this.object.getMapType() != 0) {
            Group topoGroup = new Group(dialogArea, 0);
            Messages.get();
            topoGroup.setText(Messages.MapOptions_TopologyOptions);
            gd = new GridData();
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = 2;
            topoGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            topoGroup.setLayout((Layout)layout);
            this.checkIncludeEndNodes = new Button((Composite)topoGroup, 32);
            Messages.get();
            this.checkIncludeEndNodes.setText(Messages.MapOptions_IncludeEndNodes);
            this.checkIncludeEndNodes.setSelection((this.object.getFlags() & 8) != 0);
            this.checkUseL1Topology = new Button((Composite)topoGroup, 32);
            this.checkUseL1Topology.setText("Use &physical link information");
            this.checkUseL1Topology.setSelection((this.object.getFlags() & 0x80) != 0);
            this.checkCustomRadius = new Button((Composite)topoGroup, 32);
            Messages.get();
            this.checkCustomRadius.setText(Messages.MapOptions_CustomDiscoRadius);
            this.checkCustomRadius.setSelection(this.object.getDiscoveryRadius() > 0);
            this.checkCustomRadius.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MapOptions.this.topologyRadius.setEnabled(MapOptions.this.checkCustomRadius.getSelection());
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            Messages.get();
            this.topologyRadius = WidgetHelper.createLabeledSpinner((Composite)topoGroup, (int)2048, (String)Messages.MapOptions_TopoDiscoRadius, (int)1, (int)255, (Object)"WidgetHelper::default_layout_data");
            this.topologyRadius.setSelection(this.object.getDiscoveryRadius());
            this.topologyRadius.setEnabled(this.object.getDiscoveryRadius() > 0);
        }
        Group advGroup = new Group(dialogArea, 0);
        Messages.get();
        advGroup.setText(Messages.MapOptions_AdvOptions);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        advGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        advGroup.setLayout((Layout)layout);
        this.checkCalculateStatus = new Button((Composite)advGroup, 32);
        Messages.get();
        this.checkCalculateStatus.setText(Messages.MapOptions_CalcStatusFromObjects);
        this.checkCalculateStatus.setSelection((this.object.getFlags() & 0x10) != 0);
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        int flags = 0;
        if (this.checkIncludeEndNodes != null && this.checkIncludeEndNodes.getSelection()) {
            flags |= 8;
        }
        if (this.checkShowStatusIcon.getSelection()) {
            flags |= 1;
        }
        if (this.checkShowStatusFrame.getSelection()) {
            flags |= 2;
        }
        if (this.checkShowStatusBkgnd.getSelection()) {
            flags |= 4;
        }
        if (this.checkCalculateStatus.getSelection()) {
            flags |= 0x10;
        }
        if (this.checkShowLinkDirection.getSelection()) {
            flags |= 0x40;
        }
        if (this.checkUseL1Topology.getSelection()) {
            flags |= 0x80;
        }
        md.setObjectFlags(flags, 223);
        md.setMapObjectDisplayMode(MapObjectDisplayMode.getByValue((int)this.objectDisplayMode.getSelectionIndex()));
        md.setConnectionRouting(this.routingAlgorithm.getSelectionIndex() + 1);
        if (this.radioColorCustom.getSelection()) {
            md.setLinkColor(ColorConverter.rgbToInt((RGB)this.linkColor.getColorValue()));
        } else {
            md.setLinkColor(-1);
        }
        if (this.checkCustomRadius != null) {
            if (this.checkCustomRadius.getSelection()) {
                md.setDiscoveryRadius(this.topologyRadius.getSelection());
            } else {
                md.setDiscoveryRadius(-1);
            }
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.valueOf(Messages.MapOptions_JobTitle) + this.object.getObjectName(), null, "org.netxms.ui.eclipse.networkmaps", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.valueOf(Messages.MapOptions_JobError) + MapOptions.this.object.getObjectName();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            MapOptions.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

