/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.dialogs;

import java.util.HashSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditEventTemplateDialog
extends Dialog {
    private EventTemplate eventTemplate;
    private boolean isNew;
    private LabeledText id;
    private LabeledText guid;
    private LabeledText name;
    private LabeledText message;
    private LabeledText tags;
    private LabeledText description;
    private Combo severity;
    private Button optionLog;
    private Button optionDoNotMonitor;

    public EditEventTemplateDialog(Shell parentShell, EventTemplate eventTemplate, boolean isNew) {
        super(parentShell);
        this.eventTemplate = eventTemplate;
        this.isNew = isNew;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        layout.horizontalSpacing = 8;
        dialogArea.setLayout((Layout)layout);
        this.id = new LabeledText(dialogArea, 0);
        Messages.get();
        this.id.setLabel(Messages.EditEventTemplateDialog_EventCode);
        this.id.setText(Long.toString(this.eventTemplate.getCode()));
        this.id.getTextControl().setEditable(false);
        this.guid = new LabeledText(dialogArea, 0);
        this.guid.setLabel("GUID");
        this.guid.setText(this.eventTemplate.getGuid().toString());
        this.guid.getTextControl().setEditable(false);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.guid.setLayoutData((Object)gd);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        Messages.get();
        this.severity = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)Messages.EditEventTemplateDialog_Severity, (Object)gd);
        this.severity.add(StatusDisplayInfo.getStatusText((Severity)Severity.NORMAL));
        this.severity.add(StatusDisplayInfo.getStatusText((Severity)Severity.WARNING));
        this.severity.add(StatusDisplayInfo.getStatusText((Severity)Severity.MINOR));
        this.severity.add(StatusDisplayInfo.getStatusText((Severity)Severity.MAJOR));
        this.severity.add(StatusDisplayInfo.getStatusText((Severity)Severity.CRITICAL));
        this.severity.select(this.eventTemplate.getSeverity().getValue());
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.EditEventTemplateDialog_EventName);
        this.name.setText(this.eventTemplate.getName());
        gd = new GridData();
        gd.horizontalSpan = 2;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 128;
        this.name.setLayoutData((Object)gd);
        Group optionGroup = new Group(dialogArea, 0);
        optionGroup.setText("Options");
        GridLayout optionLayout = new GridLayout();
        optionGroup.setLayout((Layout)optionLayout);
        this.optionLog = new Button((Composite)optionGroup, 32);
        Messages.get();
        this.optionLog.setText(Messages.EditEventTemplateDialog_WriteToLog);
        this.optionLog.setSelection((this.eventTemplate.getFlags() & 1) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        this.optionLog.setLayoutData((Object)gd);
        this.optionDoNotMonitor = new Button((Composite)optionGroup, 32);
        this.optionDoNotMonitor.setText("Hide from event &monitor");
        this.optionDoNotMonitor.setSelection((this.eventTemplate.getFlags() & 2) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.verticalAlignment = 0x1000000;
        this.optionDoNotMonitor.setLayoutData((Object)gd);
        this.message = new LabeledText(dialogArea, 0);
        Messages.get();
        this.message.setLabel(Messages.EditEventTemplateDialog_Message);
        this.message.setText(this.eventTemplate.getMessage());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 450;
        this.message.setLayoutData((Object)gd);
        this.tags = new LabeledText(dialogArea, 0);
        this.tags.setLabel("Tags");
        this.tags.setText(this.eventTemplate.getTagList());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 450;
        this.tags.setLayoutData((Object)gd);
        this.description = new LabeledText(dialogArea, 0, 2882);
        Messages.get();
        this.description.setLabel(Messages.EditEventTemplateDialog_Description);
        this.description.setText(this.eventTemplate.getDescription());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.heightHint = 200;
        gd.widthHint = 450;
        gd.verticalAlignment = 4;
        this.description.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.eventTemplate.setName(this.name.getText());
        this.eventTemplate.setSeverity(Severity.getByValue((int)this.severity.getSelectionIndex()));
        this.eventTemplate.setMessage(this.message.getText());
        this.eventTemplate.setDescription(this.description.getText());
        this.eventTemplate.setFlags((this.optionLog.getSelection() ? 1 : 0) | (this.optionDoNotMonitor.getSelection() ? 2 : 0));
        HashSet<String> tagSet = new HashSet<String>();
        String[] stringArray = this.tags.getText().split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            tagSet.add(s.trim());
            ++n2;
        }
        this.eventTemplate.setTags(tagSet);
        super.okPressed();
    }

    protected void configureShell(Shell newShell) {
        String string;
        if (this.isNew) {
            Messages.get();
            string = Messages.EditEventTemplateDialog_TitleCreate;
        } else {
            Messages.get();
            string = Messages.EditEventTemplateDialog_TitleEdit;
        }
        newShell.setText(string);
        super.configureShell(newShell);
    }
}

