/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.localization;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.netxms.client.NXCSession;
import org.netxms.nxmc.PreferenceStore;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class DateFormatFactory {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    private static I18n i18n = LocalizationHelper.getI18n(DateFormatFactory.class);
    private static int dateTimeFormat = 0;
    private static String dateFormatString;
    private static String timeFormatString;
    private static String shortTimeFormatString;

    public static void updateFromPreferences() {
        PreferenceStore ps = PreferenceStore.getInstance();
        dateTimeFormat = ps.getAsInteger("DateFormatFactory.Format.DateTime", 0);
        dateFormatString = ps.getAsString("DateFormatFactory.Format.Date");
        timeFormatString = ps.getAsString("DateFormatFactory.Format.Time");
        shortTimeFormatString = ps.getAsString("DateFormatFactory.Format.ShortTime");
        if (ps.getAsBoolean("DateFormatFactory.UseServerTimeZone", false)) {
            Registry.getInstance().setServerTimeZone();
        } else {
            Registry.getInstance().resetTimeZone();
        }
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getDateFormat() + " " + session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(dateFormatString + " " + timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getDateTimeInstance(3, 2);
                }
                break;
            }
            default: {
                df = DateFormat.getDateTimeInstance(3, 2);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getDateFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(dateFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getDateInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getDateInstance(3);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getTimeInstance(2);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(2);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getShortTimeFormat() {
        DateFormat df;
        switch (dateTimeFormat) {
            case 0: {
                NXCSession session = Registry.getSession();
                df = new SimpleDateFormat(session.getShortTimeFormat());
                break;
            }
            case 2: {
                try {
                    df = new SimpleDateFormat(shortTimeFormatString);
                }
                catch (IllegalArgumentException e) {
                    df = DateFormat.getTimeInstance(3);
                }
                break;
            }
            default: {
                df = DateFormat.getTimeInstance(3);
            }
        }
        TimeZone tz = Registry.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static String formatTimeDifference(Date start, boolean showSeconds) {
        int hours;
        StringBuilder sb = new StringBuilder();
        int seconds = (int)((System.currentTimeMillis() - start.getTime()) / 1000L);
        int days = seconds / 86400;
        if (days > 0) {
            sb.append(i18n.trn("{0} day", "{0} days", (long)days));
            seconds -= days * 86400;
        }
        if ((hours = seconds / 3600) < 10) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        int minutes = (seconds -= hours * 3600) / 60;
        if (minutes < 10) {
            sb.append('0');
        }
        sb.append(minutes);
        if (showSeconds) {
            sb.append(':');
            if ((seconds %= 60) < 10) {
                sb.append('0');
            }
            sb.append(seconds);
        }
        return sb.toString();
    }
}

