/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.AgentCacheMode;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.objects.Node;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpVersion;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.widgets.LabeledText;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.dialogs.IParameterSelectionDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectAgentParamDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectInternalParamDlg;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectParameterScriptDialog;
import org.netxms.nxmc.modules.datacollection.dialogs.SelectSnmpParamDlg;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.datacollection.propertypages.GeneralTable;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

/*
 * Exception performing whole class analysis ignored.
 */
public class GeneralTable
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(GeneralTable.class);
    private DataCollectionTable dci;
    private Text description;
    private LabeledText parameter;
    private Button selectButton;
    private Combo origin;
    private Button checkUseCustomSnmpPort;
    private Spinner customSnmpPort;
    private Button checkUseCustomSnmpVersion;
    private Combo customSnmpVersion;
    private ObjectSelector sourceNode;
    private Combo agentCacheMode;
    private Combo schedulingMode;
    private Combo retentionMode;
    private LabeledText pollingInterval;
    private LabeledText retentionTime;

    public GeneralTable(DataCollectionObjectEditor editor) {
        super(i18n.tr("General"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsTable();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        Group groupDescription = new Group(dialogArea, 0);
        groupDescription.setText(i18n.tr("Description"));
        FillLayout descriptionLayout = new FillLayout();
        descriptionLayout.marginWidth = 4;
        descriptionLayout.marginHeight = 4;
        groupDescription.setLayout((Layout)descriptionLayout);
        this.description = new Text((Composite)groupDescription, 2048);
        this.description.setTextLimit(255);
        this.description.setText(this.dci.getDescription());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupDescription.setLayoutData((Object)gd);
        Group groupData = new Group(dialogArea, 0);
        groupData.setText(i18n.tr("Data"));
        FormLayout dataLayout = new FormLayout();
        dataLayout.marginHeight = 4;
        dataLayout.marginWidth = 4;
        groupData.setLayout((Layout)dataLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.horizontalSpan = 2;
        groupData.setLayoutData((Object)gd);
        this.parameter = new LabeledText((Composite)groupData, 0);
        this.parameter.setLabel(i18n.tr("Parameter"));
        this.parameter.getTextControl().setTextLimit(255);
        this.parameter.setText(this.dci.getName());
        this.selectButton = new Button((Composite)groupData, 8);
        this.selectButton.setText(i18n.tr("&Select..."));
        this.selectButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment((Control)this.selectButton, -2, 16384);
        this.parameter.setLayoutData((Object)fd);
        fd = new FormData();
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.parameter, 0, 1024);
        fd.width = 90;
        this.selectButton.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(40, -2);
        this.origin = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)i18n.tr("Origin"), (Object)fd);
        this.origin.add(i18n.tr("Internal"));
        this.origin.add(i18n.tr("NetXMS Agent"));
        this.origin.add(i18n.tr("SNMP"));
        this.origin.add(i18n.tr("Web Service"));
        this.origin.add(i18n.tr("Push"));
        this.origin.add(i18n.tr("Windows Performance Counters"));
        this.origin.add(i18n.tr("SM-CLP"));
        this.origin.add(i18n.tr("Script"));
        this.origin.add(i18n.tr("SSH"));
        this.origin.add(i18n.tr("MQTT"));
        this.origin.select(this.dci.getOrigin().getValue());
        this.origin.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.checkUseCustomSnmpPort = new Button((Composite)groupData, 32);
        this.checkUseCustomSnmpPort.setText(i18n.tr("Use custom SNMP port:"));
        this.checkUseCustomSnmpPort.setSelection(this.dci.getSnmpPort() != 0);
        this.checkUseCustomSnmpPort.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        this.checkUseCustomSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpPort.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpPort = new Spinner((Composite)groupData, 2048);
        this.customSnmpPort.setMinimum(1);
        this.customSnmpPort.setMaximum(65535);
        if (this.dci.getOrigin() == DataOrigin.SNMP && this.dci.getSnmpPort() != 0) {
            this.customSnmpPort.setEnabled(true);
            this.customSnmpPort.setSelection(this.dci.getSnmpPort());
        } else {
            this.customSnmpPort.setEnabled(false);
        }
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.origin.getParent(), 4, 131072);
        fd.right = new FormAttachment((Control)this.checkUseCustomSnmpPort, 0, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 1024);
        this.customSnmpPort.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion = new Button((Composite)groupData, 32);
        this.checkUseCustomSnmpVersion.setText("Use custom SNMP version:");
        this.checkUseCustomSnmpVersion.setSelection(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        this.checkUseCustomSnmpVersion.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.parameter, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.checkUseCustomSnmpVersion.setLayoutData((Object)fd);
        this.checkUseCustomSnmpVersion.setEnabled(this.dci.getOrigin() == DataOrigin.SNMP);
        this.customSnmpVersion = new Combo((Composite)groupData, 2056);
        this.customSnmpVersion.add("1");
        this.customSnmpVersion.add("2c");
        this.customSnmpVersion.add("3");
        this.customSnmpVersion.select(GeneralTable.indexFromSnmpVersion((SnmpVersion)this.dci.getSnmpVersion()));
        this.customSnmpVersion.setEnabled(this.dci.getSnmpVersion() != SnmpVersion.DEFAULT);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.checkUseCustomSnmpPort, 4, 131072);
        fd.top = new FormAttachment((Control)this.checkUseCustomSnmpVersion, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.customSnmpVersion.setLayoutData((Object)fd);
        this.sourceNode = new ObjectSelector((Composite)groupData, 0, true);
        this.sourceNode.setLabel(i18n.tr("Source node"));
        this.sourceNode.setObjectClass(Node.class);
        this.sourceNode.setObjectId(this.dci.getSourceNode());
        this.sourceNode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        this.sourceNode.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.customSnmpPort, 4, 1024);
        fd.right = new FormAttachment(100, 0);
        this.agentCacheMode = WidgetHelper.createLabeledCombo((Composite)groupData, (int)8, (String)i18n.tr("Agent cache mode"), (Object)fd);
        this.agentCacheMode.add(i18n.tr("Default"));
        this.agentCacheMode.add(i18n.tr("On"));
        this.agentCacheMode.add(i18n.tr("Off"));
        this.agentCacheMode.select(this.dci.getCacheMode().getValue());
        this.agentCacheMode.setEnabled(this.dci.getOrigin() == DataOrigin.AGENT || this.dci.getOrigin() == DataOrigin.SNMP);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.customSnmpPort, 4, 1024);
        fd.right = new FormAttachment((Control)this.agentCacheMode.getParent(), -4, 16384);
        this.sourceNode.setLayoutData((Object)fd);
        Group groupPolling = new Group(dialogArea, 0);
        groupPolling.setText(i18n.tr("Polling"));
        FormLayout pollingLayout = new FormLayout();
        pollingLayout.marginHeight = 4;
        pollingLayout.marginWidth = 4;
        groupPolling.setLayout((Layout)pollingLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        groupPolling.setLayoutData((Object)gd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(50, -2);
        fd.top = new FormAttachment(0, 0);
        this.schedulingMode = WidgetHelper.createLabeledCombo((Composite)groupPolling, (int)8, (String)i18n.tr("Polling mode"), (Object)fd);
        this.schedulingMode.add(i18n.tr("Fixed intervals (default)"));
        this.schedulingMode.add(i18n.tr("Fixed intervals (custom)"));
        this.schedulingMode.add(i18n.tr("Custom schedule"));
        this.schedulingMode.select(this.dci.getPollingScheduleType());
        this.schedulingMode.setEnabled(this.dci.getOrigin() != DataOrigin.PUSH);
        this.schedulingMode.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.pollingInterval = new LabeledText((Composite)groupPolling, 0);
        this.pollingInterval.setLabel(i18n.tr("Polling interval (seconds)"));
        this.pollingInterval.setText(this.dci.getPollingInterval());
        this.pollingInterval.setEnabled(this.dci.getPollingScheduleType() == 1 && this.dci.getOrigin() != DataOrigin.PUSH);
        fd = new FormData();
        fd.left = new FormAttachment(50, 2);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.pollingInterval.setLayoutData((Object)fd);
        Group groupStorage = new Group(dialogArea, 0);
        groupStorage.setText(i18n.tr("Storage"));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = 2;
        groupStorage.setLayoutData((Object)gd);
        GridLayout storageLayout = new GridLayout();
        storageLayout.numColumns = 2;
        storageLayout.horizontalSpacing = 4;
        groupStorage.setLayout((Layout)storageLayout);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.retentionMode = WidgetHelper.createLabeledCombo((Composite)groupStorage, (int)8, (String)i18n.tr("Retention mode"), (Object)gd);
        this.retentionMode.add(i18n.tr("Use default retention time"));
        this.retentionMode.add(i18n.tr("Use custom retention time"));
        this.retentionMode.add(i18n.tr("Do not save collected data to database"));
        this.retentionMode.select(this.dci.getRetentionType());
        this.retentionMode.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.retentionTime = new LabeledText((Composite)groupStorage, 0);
        this.retentionTime.setLabel(i18n.tr("Retention time (days)"));
        this.retentionTime.setText(this.dci.getRetentionTime());
        this.retentionTime.setEnabled(this.dci.getRetentionType() == 1);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.retentionTime.setLayoutData((Object)gd);
        return dialogArea;
    }

    private static int indexFromSnmpVersion(SnmpVersion version) {
        switch (8.$SwitchMap$org$netxms$client$snmp$SnmpVersion[version.ordinal()]) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    private static SnmpVersion indexToSnmpVersion(int index) {
        switch (index) {
            case 0: {
                return SnmpVersion.V1;
            }
            case 1: {
                return SnmpVersion.V2C;
            }
            case 2: {
                return SnmpVersion.V3;
            }
        }
        return SnmpVersion.DEFAULT;
    }

    private void onOriginChange() {
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        this.sourceNode.setEnabled(dataOrigin != DataOrigin.PUSH);
        this.schedulingMode.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT);
        this.pollingInterval.setEnabled(dataOrigin != DataOrigin.PUSH && dataOrigin != DataOrigin.MQTT && this.schedulingMode.getSelectionIndex() == 1);
        this.checkUseCustomSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpPort.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpPort.getSelection());
        this.checkUseCustomSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP);
        this.customSnmpVersion.setEnabled(dataOrigin == DataOrigin.SNMP && this.checkUseCustomSnmpVersion.getSelection());
        this.agentCacheMode.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP);
        this.selectButton.setEnabled(dataOrigin == DataOrigin.AGENT || dataOrigin == DataOrigin.SNMP || dataOrigin == DataOrigin.INTERNAL || dataOrigin == DataOrigin.WINPERF || dataOrigin == DataOrigin.WEB_SERVICE || dataOrigin == DataOrigin.SCRIPT);
    }

    private void selectParameter() {
        SelectParameterScriptDialog dlg;
        this.editor.setSourceNode(this.sourceNode.getObjectId());
        DataOrigin dataOrigin = DataOrigin.getByValue((int)this.origin.getSelectionIndex());
        switch (8.$SwitchMap$org$netxms$client$constants$DataOrigin[dataOrigin.ordinal()]) {
            case 1: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectInternalParamDlg(this.getShell(), this.sourceNode.getObjectId(), true);
                    break;
                }
                dlg = new SelectInternalParamDlg(this.getShell(), this.dci.getNodeId(), true);
                break;
            }
            case 2: {
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectAgentParamDlg(this.getShell(), this.sourceNode.getObjectId(), dataOrigin, true);
                    break;
                }
                dlg = new SelectAgentParamDlg(this.getShell(), this.dci.getNodeId(), dataOrigin, true);
                break;
            }
            case 3: {
                SnmpObjectId oid;
                try {
                    oid = SnmpObjectId.parseSnmpObjectId((String)this.parameter.getText());
                }
                catch (SnmpObjectIdFormatException e) {
                    oid = null;
                }
                if (this.sourceNode.getObjectId() != 0L) {
                    dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.sourceNode.getObjectId());
                    break;
                }
                dlg = new SelectSnmpParamDlg(this.getShell(), oid, this.dci.getNodeId());
                break;
            }
            case 4: {
                dlg = new SelectParameterScriptDialog(this.getShell());
                break;
            }
            default: {
                dlg = null;
            }
        }
        if (dlg != null && dlg.open() == 0) {
            IParameterSelectionDialog pd = (IParameterSelectionDialog)dlg;
            this.description.setText(pd.getParameterDescription());
            this.parameter.setText(pd.getParameterName());
            this.editor.fireOnSelectTableListeners(DataOrigin.getByValue((int)this.origin.getSelectionIndex()), pd.getParameterName(), pd.getParameterDescription());
        }
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setDescription(this.description.getText().trim());
        this.dci.setName(this.parameter.getText().trim());
        this.dci.setOrigin(DataOrigin.getByValue((int)this.origin.getSelectionIndex()));
        this.dci.setSourceNode(this.sourceNode.getObjectId());
        this.dci.setCacheMode(AgentCacheMode.getByValue((int)this.agentCacheMode.getSelectionIndex()));
        this.dci.setPollingScheduleType(this.schedulingMode.getSelectionIndex());
        this.dci.setPollingInterval(this.schedulingMode.getSelectionIndex() == 1 ? this.pollingInterval.getText() : null);
        this.dci.setRetentionType(this.retentionMode.getSelectionIndex());
        this.dci.setRetentionTime(this.retentionMode.getSelectionIndex() == 1 ? this.retentionTime.getText() : null);
        if (this.checkUseCustomSnmpPort.getSelection()) {
            this.dci.setSnmpPort(Integer.parseInt(this.customSnmpPort.getText()));
        } else {
            this.dci.setSnmpPort(0);
        }
        if (this.checkUseCustomSnmpVersion.getSelection()) {
            this.dci.setSnmpVersion(GeneralTable.indexToSnmpVersion((int)this.customSnmpVersion.getSelectionIndex()));
        } else {
            this.dci.setSnmpVersion(SnmpVersion.DEFAULT);
        }
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        NXCSession session = Registry.getSession();
        this.schedulingMode.select(0);
        this.pollingInterval.setText(Integer.toString(session.getDefaultDciPollingInterval()));
        this.retentionMode.select(0);
        this.retentionTime.setText(Integer.toString(session.getDefaultDciRetentionTime()));
        this.checkUseCustomSnmpPort.setSelection(false);
    }
}

