/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.widgets;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.widgets.Composite;
import org.netxms.client.Table;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.base.views.Perspective;
import org.netxms.nxmc.base.views.View;
import org.netxms.nxmc.base.windows.PopOutViewWindow;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.charts.api.ChartType;
import org.netxms.nxmc.modules.datacollection.views.DataComparisonView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalDataView;
import org.netxms.nxmc.modules.datacollection.views.HistoricalGraphView;
import org.netxms.nxmc.modules.datacollection.widgets.BaseTableValueViewer;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.xnap.commons.i18n.I18n;

public class TableValueViewer
extends BaseTableValueViewer {
    private static final I18n i18n = LocalizationHelper.getI18n(TableValueViewer.class);
    private static long uniqueId = 1L;
    private long objectId = 0L;
    private long dciId = 0L;
    private String objectName = null;
    private Action actionShowHistory;
    private Action actionShowLineChart;
    private Action actionShowBarChart;
    private Action actionShowPieChart;

    public TableValueViewer(Composite parent, int style, ObjectView viewPart, String configSubId, boolean saveTableSettings) {
        super(parent, style, viewPart, configSubId, saveTableSettings);
    }

    protected String buildConfigId(String configSubId) {
        StringBuilder sb = new StringBuilder("TableLastValues.");
        sb.append(this.dciId);
        if (configSubId != null) {
            sb.append('.');
            sb.append(configSubId);
        }
        return sb.toString();
    }

    protected void createActions() {
        super.createActions();
        this.actionShowHistory = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowLineChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowBarChart = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowPieChart = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionShowHistory);
        manager.add((IAction)this.actionShowLineChart);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    public void setObject(long objectId, long dciId) {
        this.objectId = objectId;
        this.dciId = dciId;
        this.objectName = this.session.getObjectName(objectId);
    }

    private void showHistory() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        Perspective p = this.viewPart.getPerspective();
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            String tableName = column.getDisplayName() + ": " + instance.replace("~~~", " / ");
            AbstractObject object = this.session.findObjectById(this.objectId);
            if (p != null) {
                p.addMainView((View)new HistoricalDataView(object, object.getObjectId(), this.dciId, tableName, instance, column.getName()), true, false);
                continue;
            }
            PopOutViewWindow window = new PopOutViewWindow((View)new HistoricalDataView(object, object.getObjectId(), this.dciId, tableName, instance, column.getName()));
            window.open();
        }
    }

    private void showLineChart() {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(uniqueId++);
        ArrayList<ChartDciConfig> items = new ArrayList<ChartDciConfig>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            ChartDciConfig config = new ChartDciConfig();
            config.nodeId = this.objectId;
            config.dciId = this.dciId;
            config.dciName = column.getDisplayName() + ": " + instance.replace("~~~", " / ");
            config.dciName = config.dciName;
            config.type = 2;
            config.instance = instance;
            config.column = column.getName();
            items.add(config);
        }
        AbstractObject object = this.viewPart.getObject();
        Perspective p = this.viewPart.getPerspective();
        if (p != null) {
            p.addMainView((View)new HistoricalGraphView(object, items), true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)new HistoricalGraphView(object, items));
            window.open();
        }
    }

    private void showDataComparisonChart(ChartType chartType) {
        if (this.currentData == null) {
            return;
        }
        ViewerCell[] cells = this.cellSelectionManager.getSelectedCells();
        if (cells.length == 0) {
            return;
        }
        ArrayList<GraphItem> items = new ArrayList<GraphItem>(cells.length);
        for (int i = 0; i < cells.length; ++i) {
            TableColumnDefinition column = this.currentData.getColumnDefinition(cells[i].getColumnIndex());
            String instance = this.buildInstanceString(cells[i].getViewerRow());
            DataOrigin source = this.currentData.getSource();
            items.add(new GraphItem(this.objectId, this.dciId, source, column.getDataType(), this.currentData.getTitle(), column.getDisplayName() + ": " + instance.replace("~~~", " / "), instance, column.getName(), "%s"));
        }
        Perspective p = this.viewPart.getPerspective();
        if (p != null) {
            p.addMainView((View)new DataComparisonView(items, chartType), true, false);
        } else {
            PopOutViewWindow window = new PopOutViewWindow((View)new DataComparisonView(items, chartType));
            window.open();
        }
    }

    public long getObjectId() {
        return this.objectId;
    }

    public long getDciId() {
        return this.dciId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getTitle() {
        return this.currentData != null ? this.currentData.getTitle() : "[" + this.dciId + "]";
    }

    protected Table readData() throws Exception {
        return this.session.getTableLastValues(this.objectId, this.dciId);
    }

    protected String getReadJobName() {
        return String.format(i18n.tr("Loading data for table DCI %d"), this.dciId);
    }

    protected String getReadJobErrorMessage() {
        return String.format(i18n.tr("Cannot get data for table DCI %d"), this.dciId);
    }
}

