/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.filemanager.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Node;
import org.netxms.client.server.AgentFile;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.widgets.SortableTreeViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.filemanager.FileDownloadHelper;
import org.netxms.nxmc.modules.filemanager.dialogs.CreateFolderDialog;
import org.netxms.nxmc.modules.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.nxmc.modules.filemanager.views.AgentFileManager;
import org.netxms.nxmc.modules.filemanager.views.helpers.AgentFileComparator;
import org.netxms.nxmc.modules.filemanager.views.helpers.AgentFileFilter;
import org.netxms.nxmc.modules.filemanager.views.helpers.AgentFileLabelProvider;
import org.netxms.nxmc.modules.filemanager.views.helpers.ViewAgentFilesProvider;
import org.netxms.nxmc.modules.objects.views.ObjectView;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class AgentFileManager
extends ObjectView {
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileManager";
    private static final I18n i18n = LocalizationHelper.getI18n(AgentFileManager.class);
    private static final String TABLE_CONFIG_PREFIX = "AgentFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    public static final int COLUMN_OWNER = 4;
    public static final int COLUMN_GROUP = 5;
    public static final int COLUMN_ACCESS_RIGHTS = 6;
    private AgentFileFilter filter;
    private SortableTreeViewer viewer;
    private NXCSession session = Registry.getSession();
    private Action actionUploadFile;
    private Action actionUploadFolder;
    private Action actionDelete;
    private Action actionRename;
    private Action actionRefreshDirectory;
    private Action actionDownloadFile;
    private Action actionTailFile;
    private Action actionFingerprintFile;
    private Action actionShowFile;
    private Action actionCreateDirectory;
    private Action actionCalculateFolderSize;
    private Action actionCopyFilePath;
    private Action actionCopyFileName;

    public AgentFileManager() {
        super(i18n.tr("File Manager"), ResourceManager.getImageDescriptor((String)"icons/object-views/filemgr.png"), TABLE_CONFIG_PREFIX, true);
    }

    protected void createContent(Composite parent) {
        String[] columnNames = new String[]{i18n.tr("Name"), i18n.tr("Type"), i18n.tr("Size"), i18n.tr("Date modified"), i18n.tr("Owner"), i18n.tr("Group"), i18n.tr("Access Rights")};
        int[] columnWidths = new int[]{300, 120, 150, 150, 150, 150, 200};
        this.viewer = new SortableTreeViewer(parent, columnNames, columnWidths, 0, 128, -1);
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.viewer, (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ViewAgentFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new AgentFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AgentFileComparator());
        this.filter = new AgentFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTree().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.enableDragSupport();
        this.enableDropSupport();
        this.enableInPlaceRename();
        this.createActions();
        this.createPopupMenu();
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(3, transfers, (DragSourceListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void enableDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new AgentFileDropAdapter(this, (Viewer)this.viewer));
    }

    private void enableInPlaceRename() {
        TreeViewerEditor.create((TreeViewer)this.viewer, (ColumnViewerEditorActivationStrategy)new /* Unavailable Anonymous Inner Class!! */, (int)1);
        this.viewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)this.viewer.getTree())});
        this.viewer.setColumnProperties(new String[]{"name"});
        this.viewer.setCellModifier((ICellModifier)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doRename(AgentFile agentFile, String newName) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createActions() {
        this.actionRefreshDirectory = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+F5", (IAction)this.actionRefreshDirectory);
        this.actionUploadFile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+U", (IAction)this.actionUploadFile);
        this.actionUploadFolder = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDelete = new /* Unavailable Anonymous Inner Class!! */;
        this.actionRename = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+R", (IAction)this.actionRename);
        this.actionDownloadFile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+D", (IAction)this.actionDownloadFile);
        this.actionTailFile = new /* Unavailable Anonymous Inner Class!! */;
        this.actionShowFile = new /* Unavailable Anonymous Inner Class!! */;
        this.actionFingerprintFile = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+P", (IAction)this.actionFingerprintFile);
        this.actionCreateDirectory = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+N", (IAction)this.actionCreateDirectory);
        this.actionCalculateFolderSize = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+S", (IAction)this.actionCalculateFolderSize);
        this.actionCopyFileName = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+C", (IAction)this.actionCopyFileName);
        this.actionCopyFilePath = new /* Unavailable Anonymous Inner Class!! */;
        this.addKeyBinding("Ctrl+shift+C", (IAction)this.actionCopyFilePath);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionUploadFile);
            } else {
                mgr.add((IAction)this.actionTailFile);
                mgr.add((IAction)this.actionFingerprintFile);
                mgr.add((IAction)this.actionShowFile);
            }
        }
        mgr.add((IAction)this.actionDownloadFile);
        if (this.isFolderOnlySelection(selection)) {
            mgr.add((IAction)this.actionCalculateFolderSize);
        }
        mgr.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            if (((AgentFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionCreateDirectory);
            }
            mgr.add((IAction)this.actionRename);
        }
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            mgr.add((IAction)this.actionCopyFileName);
            mgr.add((IAction)this.actionCopyFilePath);
        }
        mgr.add((IContributionItem)new Separator());
        if (selection.size() == 1 && ((AgentFile)selection.getFirstElement()).isDirectory()) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionRefreshDirectory);
        }
    }

    private boolean isFolderOnlySelection(IStructuredSelection selection) {
        for (Object o : selection.toList()) {
            if (((AgentFile)o).isDirectory()) continue;
            return false;
        }
        return true;
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void refreshFileOrDirectory() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void uploadFile(boolean overvrite) {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        AgentFile uploadFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.getWindow().getShell());
        if (dlg.open() == 0) {
            new /* Unavailable Anonymous Inner Class!! */.start();
        }
    }

    private void uploadFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        FileDownloadHelper.uploadFolder((long)this.getObjectId(), (IStructuredSelection)selection, (AgentFileManager)this, (SortableTreeViewer)this.viewer);
    }

    private void deleteFile() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openConfirm((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete confirmation"), (String)i18n.tr("Are you sure you want to delete this file?"))) {
            return;
        }
        Object[] objects = selection.toArray();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void showFile(boolean followChanges, int offset) {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentFile agentFile = (AgentFile)selection.getFirstElement();
        if (agentFile.isDirectory()) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void getFileFingerprint() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        AgentFile file = (AgentFile)selection.getFirstElement();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void startDownload() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        FileDownloadHelper.startDownload((long)this.getObjectId(), (IStructuredSelection)selection, (AgentFileManager)this);
    }

    private void renameFile() {
        ITreeSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() == 1) {
            this.viewer.editElement(selection.getFirstElement(), 0);
        }
    }

    private void moveFile(AgentFile target, AgentFile object) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyFile(AgentFile target, AgentFile object) {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createFolder() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        AgentFile parentFolder = ((AgentFile)objects[0]).isDirectory() ? (AgentFile)objects[0] : ((AgentFile)objects[0]).getParent();
        CreateFolderDialog dlg = new CreateFolderDialog(this.getWindow().getShell());
        if (dlg.open() != 0) {
            return;
        }
        String newFolder = dlg.getNewName();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void calculateFolderSize() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<AgentFile> files = new ArrayList<AgentFile>(selection.size());
        for (Object o : selection.toList()) {
            files.add((AgentFile)o);
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void copyFileName() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        WidgetHelper.copyToClipboard((String)((AgentFile)selection.getFirstElement()).getName());
    }

    private void copyFilePath() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        WidgetHelper.copyToClipboard((String)((AgentFile)selection.getFirstElement()).getFilePath());
    }

    protected void onObjectChange(AbstractObject object) {
        if (object == null) {
            return;
        }
        this.refresh();
        String os = ((Node)this.session.findObjectById(this.getObjectId())).getSystemDescription();
        if (os.contains("Windows")) {
            this.viewer.removeColumnById(5);
            this.viewer.removeColumnById(6);
        } else {
            this.viewer.addColumn(i18n.tr("Group"), 150);
            this.viewer.addColumn(i18n.tr("Access Rights"), 200);
        }
    }

    public boolean isValidForContext(Object context) {
        if (context != null && context instanceof Node) {
            return (((Node)context).getCapabilities() & 0x4000000) != 0;
        }
        return false;
    }

    public int getPriority() {
        return 44;
    }
}

