/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.objects.propertypages;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.objects.propertypages.ObjectPropertyPage;
import org.netxms.nxmc.modules.objects.propertypages.ZoneAgentCredentials;
import org.xnap.commons.i18n.I18n;

public class ZoneAgentCredentials
extends ObjectPropertyPage {
    private static I18n i18n = LocalizationHelper.getI18n(ZoneAgentCredentials.class);
    private Zone zone;
    private List<String> sharedSecrets;
    private List<Integer> ports;
    private TableViewer secretList;
    private Button secretMoveUpButton;
    private Button secretMoveDownButton;
    private Button secretAddButton;
    private Button secretDeleteButton;
    private TableViewer portList;
    private Button portMoveUpButton;
    private Button portMoveDownButton;
    private Button portAddButton;
    private Button portDeleteButton;
    private int modified = 0;

    public ZoneAgentCredentials(AbstractObject object) {
        super(i18n.tr("Agent Credentials"), object);
    }

    public String getId() {
        return "zoneCommunications.agentCredentials";
    }

    public String getParentId() {
        return "zoneCommunications";
    }

    public boolean isVisible() {
        return this.object instanceof Zone;
    }

    protected Control createContents(Composite parent) {
        this.zone = (Zone)this.object;
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.createSecretSection(dialogArea);
        this.createPortSection(dialogArea);
        this.loadConfig();
        return dialogArea;
    }

    private void createSecretSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Shared secrets");
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        clientArea.setLayoutData((Object)gridData);
        this.secretList = new TableViewer((Composite)clientArea, 67586);
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        gridData.heightHint = 150;
        this.secretList.getTable().setLayoutData((Object)gridData);
        this.secretList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gridData);
        this.secretMoveUpButton = new Button(buttonsLeft, 8);
        this.secretMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.secretMoveUpButton.setLayoutData((Object)rd);
        this.secretMoveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.secretMoveDownButton = new Button(buttonsLeft, 8);
        this.secretMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.secretMoveDownButton.setLayoutData((Object)rd);
        this.secretMoveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gridData);
        this.secretAddButton = new Button(buttonsRight, 8);
        this.secretAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.secretAddButton.setLayoutData((Object)rd);
        this.secretAddButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.secretDeleteButton = new Button(buttonsRight, 8);
        this.secretDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.secretDeleteButton.setLayoutData((Object)rd);
        this.secretDeleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.secretList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadConfig() {
        NXCSession session = Registry.getSession();
        6 job = new /* Unavailable Anonymous Inner Class!! */;
        job.start();
    }

    private void addSharedSecret() {
        InputDialog dlg = new InputDialog(this.getShell(), "Add Shared Secret", "Please enter shared secret", "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.sharedSecrets.add(value);
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    protected void removeSharedSecret() {
        IStructuredSelection selection = this.secretList.getStructuredSelection();
        if (!selection.isEmpty()) {
            for (Object o : selection.toList()) {
                this.sharedSecrets.remove(o);
            }
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    private void moveSharedSecret(boolean up) {
        IStructuredSelection selection = this.secretList.getStructuredSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.sharedSecrets.indexOf(o);
                if (up) {
                    if (index < 1) continue;
                    Collections.swap(this.sharedSecrets, index - 1, index);
                    continue;
                }
                if (index + 1 == this.sharedSecrets.size()) continue;
                Collections.swap(this.sharedSecrets, index + 1, index);
            }
            this.secretList.refresh();
            this.setModified(8);
        }
    }

    private void createPortSection(Composite dialogArea) {
        Group clientArea = new Group(dialogArea, 0);
        clientArea.setText("Ports");
        clientArea.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        clientArea.setLayout((Layout)layout);
        this.portList = new TableViewer((Composite)clientArea, 67586);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.heightHint = 150;
        this.portList.getTable().setLayoutData((Object)gd);
        this.portList.setContentProvider((IContentProvider)new ArrayContentProvider());
        Composite buttonsLeft = new Composite((Composite)clientArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsLeft.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        buttonsLeft.setLayoutData((Object)gd);
        this.portMoveUpButton = new Button(buttonsLeft, 8);
        this.portMoveUpButton.setText("&Up");
        RowData rd = new RowData();
        rd.width = 90;
        this.portMoveUpButton.setLayoutData((Object)rd);
        this.portMoveUpButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portMoveDownButton = new Button(buttonsLeft, 8);
        this.portMoveDownButton.setText("&Down");
        rd = new RowData();
        rd.width = 90;
        this.portMoveDownButton.setLayoutData((Object)rd);
        this.portMoveDownButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        Composite buttonsRight = new Composite((Composite)clientArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttonsRight.setLayout((Layout)buttonLayout);
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttonsRight.setLayoutData((Object)gd);
        this.portAddButton = new Button(buttonsRight, 8);
        this.portAddButton.setText("Add");
        rd = new RowData();
        rd.width = 90;
        this.portAddButton.setLayoutData((Object)rd);
        this.portAddButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portDeleteButton = new Button(buttonsRight, 8);
        this.portDeleteButton.setText("Delete");
        rd = new RowData();
        rd.width = 90;
        this.portDeleteButton.setLayoutData((Object)rd);
        this.portDeleteButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.portList.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addPort() {
        InputDialog dlg = new InputDialog(this.getShell(), i18n.tr("Add Agent Port"), i18n.tr("Please enter agent port"), "", null);
        if (dlg.open() == 0) {
            String value = dlg.getValue();
            this.ports.add(Integer.parseInt(value));
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void removePort() {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                this.ports.remove((Integer)o);
            }
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void movePort(boolean up) {
        IStructuredSelection selection = (IStructuredSelection)this.portList.getSelection();
        if (selection.size() > 0) {
            for (Object o : selection.toList()) {
                int index = this.ports.indexOf((Integer)o);
                if (up) {
                    if (index < 1) continue;
                    Collections.swap(this.ports, index - 1, index);
                    continue;
                }
                if (index + 1 == this.ports.size()) continue;
                Collections.swap(this.ports, index + 1, index);
            }
            this.portList.refresh();
            this.setModified(16);
        }
    }

    private void setModified(int configId) {
        this.modified |= configId;
    }

    protected boolean applyChanges(boolean isApply) {
        if (this.modified == 0) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        NXCSession session = Registry.getSession();
        new /* Unavailable Anonymous Inner Class!! */.start();
        return true;
    }
}

