/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.serverconfig.views;

import java.util.ArrayList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.NotificationChannel;
import org.netxms.client.SessionListener;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.base.views.AbstractViewerFilter;
import org.netxms.nxmc.base.views.ConfigurationView;
import org.netxms.nxmc.base.widgets.SortableTableViewer;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.serverconfig.dialogs.NotificationChannelPropertiesDialog;
import org.netxms.nxmc.modules.serverconfig.views.helpers.NotificationChannelFilter;
import org.netxms.nxmc.modules.serverconfig.views.helpers.NotificationChannelLabelProvider;
import org.netxms.nxmc.modules.serverconfig.views.helpers.NotificationChannelListComparator;
import org.netxms.nxmc.resources.ResourceManager;
import org.netxms.nxmc.tools.MessageDialogHelper;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class NotificationChannels
extends ConfigurationView {
    private static final I18n i18n = LocalizationHelper.getI18n(NotificationChannels.class);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_DESCRIPTION = 1;
    public static final int COLUMN_DRIVER = 2;
    public static final int COLUMN_TOTAL_MESSAGES = 3;
    public static final int COLUMN_FAILED_MESSAGES = 4;
    public static final int COLUMN_LAST_STATUS = 5;
    public static final int COLUMN_ERROR_MESSAGE = 6;
    private NXCSession session = Registry.getSession();
    private SessionListener listener;
    private SortableTableViewer viewer;
    private Action actionNewChannel;
    private Action actionEditChannel;
    private Action actionDeleteChannel;

    public NotificationChannels() {
        super(i18n.tr("Notification Channels"), ResourceManager.getImageDescriptor((String)"icons/config-views/nchannels.png"), "NotificationChannels", true);
    }

    protected void createContent(Composite parent) {
        int[] widths = new int[]{160, 250, 100, 100, 100, 80, 400};
        String[] names = new String[]{i18n.tr("Name"), i18n.tr("Description"), i18n.tr("Driver"), i18n.tr("Messages"), i18n.tr("Failures"), i18n.tr("Status"), i18n.tr("Error message")};
        this.viewer = new SortableTableViewer(parent, names, widths, 0, 128, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (String)"NotificationChannelList");
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new NotificationChannelLabelProvider());
        this.viewer.setComparator((ViewerComparator)new NotificationChannelListComparator());
        NotificationChannelFilter filter = new NotificationChannelFilter();
        this.viewer.addFilter((ViewerFilter)filter);
        this.setFilterClient((ISelectionProvider)this.viewer, (AbstractViewerFilter)filter);
        this.viewer.addDoubleClickListener((IDoubleClickListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.viewer.getTable().addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.createActions();
        this.createContextMenu();
        Display display = this.viewer.getControl().getDisplay();
        this.listener = new /* Unavailable Anonymous Inner Class!! */;
        this.session.addListener(this.listener);
    }

    public void dispose() {
        this.session.removeListener(this.listener);
        super.dispose();
    }

    protected void postContentCreate() {
        this.refresh();
    }

    private void createActions() {
        this.actionNewChannel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditChannel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionEditChannel.setEnabled(false);
        this.actionDeleteChannel = new /* Unavailable Anonymous Inner Class!! */;
        this.actionDeleteChannel.setEnabled(false);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new /* Unavailable Anonymous Inner Class!! */);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNewChannel);
        mgr.add((IAction)this.actionEditChannel);
        mgr.add((IAction)this.actionDeleteChannel);
    }

    protected void fillLocalToolbar(ToolBarManager manager) {
        manager.add((IAction)this.actionNewChannel);
    }

    protected void fillLocalMenu(MenuManager manager) {
        manager.add((IAction)this.actionNewChannel);
    }

    public void refresh() {
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void createNewChannel() {
        NotificationChannelPropertiesDialog dlg = new NotificationChannelPropertiesDialog(this.getWindow().getShell(), null);
        if (dlg.open() != 0) {
            return;
        }
        NotificationChannel channel = dlg.getNotificaiotnChannel();
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void editChannel() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        NotificationChannel channel = (NotificationChannel)selection.getFirstElement();
        NotificationChannelPropertiesDialog dlg = new NotificationChannelPropertiesDialog(this.getWindow().getShell(), channel);
        if (dlg.open() != 0) {
            return;
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    private void deleteChannels() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getWindow().getShell(), (String)i18n.tr("Delete Channels"), (String)i18n.tr("Are you sure you want to delete selected notification channels?"))) {
            return;
        }
        ArrayList<String> channels = new ArrayList<String>(selection.size());
        for (Object o : selection.toList()) {
            if (!(o instanceof NotificationChannel)) continue;
            channels.add(((NotificationChannel)o).getName());
        }
        new /* Unavailable Anonymous Inner Class!! */.start();
    }

    public boolean isModified() {
        return false;
    }

    public void save() {
    }
}

