/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.ui.IViewPart;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.ChartConfiguration;
import org.netxms.client.datacollection.ChartDciConfig;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.ChartType;
import org.netxms.ui.eclipse.charts.widgets.Chart;
import org.netxms.ui.eclipse.dashboard.widgets.ComparisonChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.internal.GaugeConfig;

public class GaugeElement
extends ComparisonChartElement {
    private GaugeConfig elementConfig;

    public GaugeElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.elementConfig = GaugeConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.elementConfig = new GaugeConfig();
        }
        this.processCommonSettings(this.elementConfig);
        this.refreshInterval = this.elementConfig.getRefreshRate();
        ChartConfiguration chartConfig = new ChartConfiguration();
        chartConfig.setTitleVisible(false);
        chartConfig.setLegendVisible(false);
        chartConfig.setLegendPosition(this.elementConfig.getLegendPosition());
        chartConfig.setLabelsVisible(this.elementConfig.isShowLegend());
        chartConfig.setLabelsInside(this.elementConfig.isLegendInside());
        chartConfig.setTransposed(this.elementConfig.isVertical());
        chartConfig.setElementBordersVisible(this.elementConfig.isElementBordersVisible());
        chartConfig.setMinYScaleValue(this.elementConfig.getMinValue());
        chartConfig.setMaxYScaleValue(this.elementConfig.getMaxValue());
        chartConfig.setLeftYellowZone(this.elementConfig.getLeftYellowZone());
        chartConfig.setLeftRedZone(this.elementConfig.getLeftRedZone());
        chartConfig.setRightYellowZone(this.elementConfig.getRightYellowZone());
        chartConfig.setRightRedZone(this.elementConfig.getRightRedZone());
        chartConfig.setFontName(this.elementConfig.getFontName());
        chartConfig.setGaugeColorMode(this.elementConfig.getColorMode());
        switch (this.elementConfig.getGaugeType()) {
            case 1: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.GAUGE, chartConfig);
                this.updateThresholds = true;
                break;
            }
            case 2: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.TEXT, chartConfig);
                this.updateThresholds = true;
                break;
            }
            default: {
                this.chart = new Chart(this.getContentArea(), 0, ChartType.DIAL, chartConfig);
            }
        }
        this.chart.setDrillDownObjectId(this.elementConfig.getDrillDownObjectId());
        ChartDciConfig[] chartDciConfigArray = this.elementConfig.getDciList();
        int n = chartDciConfigArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChartDciConfig dci = chartDciConfigArray[n2];
            this.chart.addParameter(new GraphItem(dci, DataOrigin.INTERNAL, DataType.INT32));
            ++n2;
        }
        this.chart.setPaletteEntry(0, new ChartColor(this.elementConfig.getCustomColor()));
        this.chart.rebuild();
        this.startRefreshTimer();
    }

    @Override
    protected ChartDciConfig[] getDciList() {
        return this.elementConfig.getDciList();
    }
}

