/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.networkmaps.views.AbstractNetworkMapView;

public class InternalConnectionTopology
extends AbstractNetworkMapView {
    public static final String ID = "org.netxms.ui.eclipse.networkmaps.views.InternalConnectionMap";

    @Override
    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.setPartName("Internal Connection Map - " + this.rootObject.getObjectName());
    }

    @Override
    protected void buildMapPage() {
        if (this.mapPage == null) {
            this.mapPage = new NetworkMapPage(ID + this.rootObject.getObjectName());
        }
        new ConsoleJob(String.format("Get internal connection map for %s", this.rootObject.getObjectName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.networkmaps"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                NetworkMapPage page = InternalConnectionTopology.this.session.queryInternalConnectionTopology(InternalConnectionTopology.this.rootObject.getObjectId());
                InternalConnectionTopology.this.replaceMapPage(page, this.getDisplay());
            }

            protected void jobFailureHandler() {
                NetworkMapPage page = new NetworkMapPage(InternalConnectionTopology.ID + InternalConnectionTopology.this.rootObject.getObjectName());
                page.addElement((NetworkMapElement)new NetworkMapObject(InternalConnectionTopology.this.mapPage.createElementId(), InternalConnectionTopology.this.rootObject.getObjectId()));
                InternalConnectionTopology.this.replaceMapPage(page, this.getDisplay());
            }

            protected String getErrorMessage() {
                return String.format("Cannot get internal connection map for %s", InternalConnectionTopology.this.rootObject.getObjectName());
            }
        }.start();
    }
}

