/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.logviewer.views.helpers;

import java.util.Collection;
import java.util.Date;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.TableRow;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.events.EventTemplate;
import org.netxms.client.log.Log;
import org.netxms.client.log.LogColumn;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Zone;
import org.netxms.client.users.AbstractUserObject;
import org.netxms.ui.eclipse.console.UserRefreshRunnable;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.logviewer.Activator;
import org.netxms.ui.eclipse.logviewer.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LogLabelProvider
implements ITableLabelProvider {
    public static final String[] ALARM_STATE_TEXTS;
    public static final String[] ALARM_HD_STATE_TEXTS;
    public static final String[] EVENT_ORIGIN_TEXTS;
    private LogColumn[] columns;
    private NXCSession session;
    private Image[] alarmStateImages;
    private WorkbenchLabelProvider wbLabelProvider;
    private TableViewer viewer;

    static {
        String[] stringArray = new String[4];
        Messages.get();
        stringArray[0] = Messages.LogLabelProvider_Outstanding;
        Messages.get();
        stringArray[1] = Messages.LogLabelProvider_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.LogLabelProvider_Resolved;
        Messages.get();
        stringArray[3] = Messages.LogLabelProvider_Terminated;
        ALARM_STATE_TEXTS = stringArray;
        String[] stringArray2 = new String[3];
        Messages.get();
        stringArray2[0] = Messages.LogLabelProvider_Ignored;
        Messages.get();
        stringArray2[1] = Messages.LogLabelProvider_Open;
        Messages.get();
        stringArray2[2] = Messages.LogLabelProvider_Closed;
        ALARM_HD_STATE_TEXTS = stringArray2;
        EVENT_ORIGIN_TEXTS = new String[]{"System", "Agent", "Client", "Syslog", "SNMP", "Script", "Remote Server", "Windows Event"};
    }

    public LogLabelProvider(Log logHandle, TableViewer viewer) {
        this.viewer = viewer;
        Collection c = logHandle.getColumns();
        this.columns = c.toArray(new LogColumn[c.size()]);
        this.session = ConsoleSharedData.getSession();
        this.alarmStateImages = new Image[4];
        this.alarmStateImages[0] = Activator.getImageDescriptor("icons/outstanding.png").createImage();
        this.alarmStateImages[1] = Activator.getImageDescriptor("icons/acknowledged.png").createImage();
        this.alarmStateImages[2] = Activator.getImageDescriptor("icons/resolved.png").createImage();
        this.alarmStateImages[3] = Activator.getImageDescriptor("icons/terminated.png").createImage();
        this.wbLabelProvider = new WorkbenchLabelProvider();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        String value = ((TableRow)element).get(columnIndex).getValue();
        switch (this.columns[columnIndex].getType()) {
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return this.alarmStateImages[state & 0xF];
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 2: {
                try {
                    long id = Long.parseLong(value);
                    AbstractObject object = this.session.findObjectById(id);
                    return object != null ? this.wbLabelProvider.getImage((Object)object) : null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusImage((int)severity);
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 13: {
                try {
                    int status = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusImage((int)(status > 0 ? ObjectStatus.NORMAL.getValue() : ObjectStatus.MAJOR.getValue()));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 3: {
                try {
                    long id = Long.parseLong(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id, (Runnable)new UserRefreshRunnable((ColumnViewer)this.viewer, element));
                    return user != null ? this.wbLabelProvider.getImage((Object)user) : null;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, int columnIndex) {
        String value = ((TableRow)element).get(columnIndex).getValue();
        switch (this.columns[columnIndex].getType()) {
            case 8: {
                try {
                    int state = Integer.parseInt(value);
                    return ALARM_HD_STATE_TEXTS[state];
                }
                catch (Exception e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 7: {
                try {
                    int state = Integer.parseInt(value);
                    return ALARM_STATE_TEXTS[state & 0xF];
                }
                catch (Exception e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 4: {
                try {
                    String string;
                    long code = Long.parseLong(value);
                    EventTemplate evt = this.session.findEventTemplateByCode(code);
                    if (evt != null) {
                        string = evt.getName();
                        return string;
                    }
                    string = "[" + code + "]";
                    return string;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 10: {
                try {
                    int origin = Integer.parseInt(value);
                    return EVENT_ORIGIN_TEXTS[origin];
                }
                catch (Exception e) {
                    return value;
                }
            }
            case 2: {
                try {
                    String string;
                    long id = Long.parseLong(value);
                    if (id == 0L) {
                        return "";
                    }
                    AbstractObject object = this.session.findObjectById(id);
                    if (object != null) {
                        string = object.getObjectName();
                        return string;
                    }
                    string = "[" + id + "]";
                    return string;
                }
                catch (NumberFormatException e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 1: {
                try {
                    int severity = Integer.parseInt(value);
                    return StatusDisplayInfo.getStatusText((int)severity);
                }
                catch (NumberFormatException e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 13: {
                try {
                    int status = Integer.parseInt(value);
                    if (status <= 0) return "Failure";
                    return "Success";
                }
                catch (NumberFormatException e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 5: {
                try {
                    long timestamp = Long.parseLong(value);
                    Date date = new Date(timestamp * 1000L);
                    return RegionalSettings.getDateTimeFormat().format(date);
                }
                catch (NumberFormatException e) {
                    Messages.get();
                    return Messages.LogLabelProvider_Error;
                }
            }
            case 3: {
                try {
                    long id = Long.parseLong(value);
                    AbstractUserObject user = this.session.findUserDBObjectById(id, (Runnable)new UserRefreshRunnable((ColumnViewer)this.viewer, element));
                    if (user == null) return null;
                    String string = this.wbLabelProvider.getText((Object)user);
                    return string;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case 9: {
                try {
                    String string;
                    int uin = Integer.parseInt(value);
                    Zone zone = this.session.findZone(uin);
                    if (zone != null) {
                        string = zone.getObjectName();
                        return string;
                    }
                    string = "[" + uin + "]";
                    return string;
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        int i = 0;
        while (i < this.alarmStateImages.length) {
            if (this.alarmStateImages[i] != null) {
                this.alarmStateImages[i].dispose();
            }
            ++i;
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

