/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ConfigurationImportDialog
extends Dialog {
    private Text textFileName;
    private Button browseButton;
    private Button replaceEvents;
    private Button replaceActions;
    private Button replaceTemplates;
    private Button replaceTemplateNamesAndLocations;
    private Button removeEmptyTemplateGroups;
    private Button replaceTraps;
    private Button replaceScripts;
    private Button replaceSummaryTables;
    private Button replaceObjectTools;
    private Button replaceRules;
    private Button replaceWebServiceDefinitions;
    private String fileName;
    private int flags;

    public ConfigurationImportDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.textFileName = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.ConfigurationImportDialog_FileName, null, (Object)"WidgetHelper::default_layout_data");
        this.browseButton = new Button(dialogArea, 8);
        Messages.get();
        this.browseButton.setText(Messages.ConfigurationImportDialog_Browse);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        gd.widthHint = 90;
        this.browseButton.setLayoutData((Object)gd);
        this.browseButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ConfigurationImportDialog.this.getShell(), 4096);
                Messages.get();
                fd.setText(Messages.ConfigurationImportDialog_SelectFile);
                fd.setFilterExtensions(new String[]{"*.xml", "*.*"});
                String[] stringArray = new String[2];
                Messages.get();
                stringArray[0] = Messages.ConfigurationImportDialog_FileTypeXML;
                Messages.get();
                stringArray[1] = Messages.ConfigurationImportDialog_FileTypeAll;
                fd.setFilterNames(stringArray);
                String selected = fd.open();
                if (selected != null) {
                    ConfigurationImportDialog.this.textFileName.setText(selected);
                }
            }
        });
        Group options = new Group(dialogArea, 0);
        FillLayout optionsLayout = new FillLayout(512);
        optionsLayout.spacing = 4;
        options.setLayout((Layout)optionsLayout);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        options.setLayoutData((Object)gd);
        this.replaceActions = new Button((Composite)options, 32);
        this.replaceActions.setText("Replace existing &actions");
        this.replaceSummaryTables = new Button((Composite)options, 32);
        this.replaceSummaryTables.setText("Replace existing &DCI summary tables");
        this.replaceRules = new Button((Composite)options, 32);
        this.replaceRules.setText("Replace existing EPP &rules");
        this.replaceEvents = new Button((Composite)options, 32);
        this.replaceEvents.setText("Replace existing &events");
        this.replaceScripts = new Button((Composite)options, 32);
        this.replaceScripts.setText("Replace existing library &scripts");
        this.replaceObjectTools = new Button((Composite)options, 32);
        this.replaceObjectTools.setText("Replace existing &object tools");
        this.replaceTraps = new Button((Composite)options, 32);
        this.replaceTraps.setText("Replace existing S&NMP traps");
        this.replaceTemplates = new Button((Composite)options, 32);
        this.replaceTemplates.setText("Replace existing &templates");
        this.replaceTemplateNamesAndLocations = new Button((Composite)options, 32);
        this.replaceTemplateNamesAndLocations.setText("Replace existing &template &names and &locations");
        this.removeEmptyTemplateGroups = new Button((Composite)options, 32);
        this.removeEmptyTemplateGroups.setText("Remove empty template groups after import");
        this.replaceWebServiceDefinitions = new Button((Composite)options, 32);
        this.replaceWebServiceDefinitions.setText("Replace web service definitions");
        return dialogArea;
    }

    protected void okPressed() {
        this.fileName = this.textFileName.getText();
        this.flags = 0;
        if (this.replaceActions.getSelection()) {
            this.flags |= 2;
        }
        if (this.replaceEvents.getSelection()) {
            this.flags |= 1;
        }
        if (this.replaceObjectTools.getSelection()) {
            this.flags |= 0x40;
        }
        if (this.replaceRules.getSelection()) {
            this.flags |= 0x80;
        }
        if (this.replaceScripts.getSelection()) {
            this.flags |= 0x10;
        }
        if (this.replaceSummaryTables.getSelection()) {
            this.flags |= 0x20;
        }
        if (this.replaceTemplates.getSelection()) {
            this.flags |= 4;
        }
        if (this.replaceTemplateNamesAndLocations.getSelection()) {
            this.flags |= 0x100;
        }
        if (this.removeEmptyTemplateGroups.getSelection()) {
            this.flags |= 0x200;
        }
        if (this.replaceTraps.getSelection()) {
            this.flags |= 8;
        }
        if (this.replaceWebServiceDefinitions.getSelection()) {
            this.flags |= 0x400;
        }
        super.okPressed();
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getFlags() {
        return this.flags;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.ConfigurationImportDialog_Title);
    }
}

