/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconsole.views.helpers;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class TerminalReader
extends Reader {
    private static final byte[] BACKSPACE_SEQUENCE = new byte[]{8, 32, 8};
    private static final int ESC_NORMAL = 0;
    private static final int ESC_START = 1;
    private static final int ESC_91 = 2;
    private static final int ESC_5X = 3;
    private Reader in;
    private OutputStream terminal;
    private StringBuilder command;
    private List<String> history = new ArrayList<String>();
    private int historyPos;

    public TerminalReader(Reader in, OutputStream terminal) {
        this.in = in;
        this.terminal = terminal;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        return this.in.read(cbuf, off, len);
    }

    public String readLine() throws IOException {
        this.writeToTerminal("\u001b[33mnetxmsd:\u001b[0m ");
        this.historyPos = this.history.size();
        int escState = 0;
        this.command = new StringBuilder();
        block7: while (true) {
            int ch = this.in.read();
            if (escState != 0) {
                escState = this.processEscape(escState, ch);
                continue;
            }
            if (ch == 13) break;
            switch (ch) {
                case 3: {
                    this.clearInput();
                    continue block7;
                }
                case 8: {
                    if (this.command.length() <= 0) continue block7;
                    this.terminal.write(BACKSPACE_SEQUENCE);
                    this.command.deleteCharAt(this.command.length() - 1);
                    continue block7;
                }
                case 12: {
                    this.writeToTerminal("\u001b[2J\u001b[H\u001b[33mnetxmsd:\u001b[0m ");
                    this.writeToTerminal(this.command.toString());
                    continue block7;
                }
                case 27: {
                    escState = 1;
                    continue block7;
                }
                case 10: {
                    continue block7;
                }
            }
            this.command.append((char)ch);
        }
        String line = this.command.toString().trim();
        if (!(line.isEmpty() || this.history.size() != 0 && this.history.get(this.history.size() - 1).compareTo(line) == 0)) {
            this.history.add(line);
        }
        return line;
    }

    private int processEscape(int state, int ch) {
        switch (state) {
            case 1: {
                return ch == 91 ? 2 : 0;
            }
            case 2: {
                switch (ch) {
                    case 50: 
                    case 51: {
                        return 3;
                    }
                    case 65: {
                        this.prevCommand();
                        return 0;
                    }
                    case 66: {
                        this.nextCommand();
                        return 0;
                    }
                }
                return 0;
            }
        }
        return 0;
    }

    private void clearInput() {
        this.writeToTerminal("\u001b[" + this.command.length() + "D\u001b[0J");
        this.command = new StringBuilder();
    }

    private void prevCommand() {
        if (this.historyPos == 0) {
            return;
        }
        this.clearInput();
        String line = this.history.get(--this.historyPos);
        this.command.append(line);
        this.writeToTerminal(line);
    }

    private void nextCommand() {
        if (this.historyPos == this.history.size()) {
            return;
        }
        this.clearInput();
        if (this.historyPos < this.history.size() - 1) {
            String line = this.history.get(++this.historyPos);
            this.command.append(line);
            this.writeToTerminal(line);
        }
    }

    private void writeToTerminal(String text) {
        try {
            this.terminal.write(text.getBytes());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

