/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.GeoLocation;
import org.netxms.base.KMLParser;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.osm.Activator;
import org.netxms.ui.eclipse.osm.dialogs.GeoAreaEditDialog;
import org.netxms.ui.eclipse.osm.views.helpers.GeoAreaComparator;
import org.netxms.ui.eclipse.osm.views.helpers.GeoAreaFilter;
import org.netxms.ui.eclipse.osm.views.helpers.GeoAreaLabelProvider;
import org.netxms.ui.eclipse.osm.widgets.GeoAreaViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class GeoAreaManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.GeoAreaManager";
    public static final int COL_ID = 0;
    public static final int COL_NAME = 1;
    public static final int COL_COMMENTS = 2;
    private static final String TABLE_CONFIG_PREFIX = "GeoAreaManager";
    private Map<Integer, GeoArea> areas = new HashMap<Integer, GeoArea>();
    private Display display;
    private SashForm splitter;
    private SortableTableViewer viewer;
    private NXCSession session;
    private Composite content;
    private FilterText filterText;
    private GeoAreaFilter filter;
    private Composite details;
    private TableViewer coordinateListViewer;
    private GeoAreaViewer mapViewer;
    private boolean initShowFilter = true;
    private Action actionRefresh;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionImport;
    private Action actionShowFilter;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.initShowFilter = GeoAreaManager.getBooleanSetting("ObjectTools.showFilter", this.initShowFilter);
        this.session = ConsoleSharedData.getSession();
    }

    private static boolean getBooleanSetting(String name, boolean defval) {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        if (settings.get(name) == null) {
            return defval;
        }
        return settings.getBoolean(name);
    }

    public void createPartControl(Composite parent) {
        this.display = parent.getDisplay();
        this.splitter = new SashForm(parent, 256);
        this.content = new Composite((Composite)this.splitter, 0);
        FormLayout formLayout = new FormLayout();
        this.content.setLayout((Layout)formLayout);
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeoAreaManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                GeoAreaManager.this.enableFilter(false);
                GeoAreaManager.this.actionShowFilter.setChecked(GeoAreaManager.this.initShowFilter);
            }
        });
        String[] names = new String[]{"ID", "Name", "Comments"};
        int[] widths = new int[]{100, 400, 800};
        this.viewer = new SortableTableViewer(this.content, names, widths, 1, 1024, 65538);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new GeoAreaLabelProvider());
        this.viewer.setComparator((ViewerComparator)new GeoAreaComparator());
        this.filter = new GeoAreaFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    GeoAreaManager.this.actionEdit.setEnabled(selection.size() == 1);
                    GeoAreaManager.this.actionDelete.setEnabled(selection.size() > 0);
                    GeoAreaManager.this.updateAreaDetails((GeoArea)selection.getFirstElement());
                }
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                GeoAreaManager.this.actionEdit.run();
            }
        });
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)GeoAreaManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)GeoAreaManager.TABLE_CONFIG_PREFIX);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.details = new Composite((Composite)this.splitter, 0);
        this.details.setLayout((Layout)new FillLayout(512));
        this.coordinateListViewer = new TableViewer(this.details);
        this.coordinateListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.mapViewer = new GeoAreaViewer(this.details, 2048);
        this.mapViewer.enableMapControls(false);
        this.splitter.setWeights(new int[]{60, 40});
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.session.addListener((SessionListener)this);
        if (this.initShowFilter) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refresh();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 1050) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GeoArea area = (GeoArea)n.getObject();
                    GeoAreaManager.this.areas.put(area.getId(), area);
                    GeoAreaManager.this.viewer.refresh(true);
                }
            });
        } else if (n.getCode() == 1051) {
            this.display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    GeoAreaManager.this.areas.remove((int)n.getSubCode());
                    GeoAreaManager.this.viewer.refresh();
                }
            });
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.osm.context.GeoAreaManager");
        }
    }

    public void enableFilter(boolean enable) {
        this.initShowFilter = enable;
        this.filterText.setVisible(this.initShowFilter);
        FormData fd = (FormData)this.viewer.getTable().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText, 0, 1024) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    public void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionShowFilter = new Action("Show &filter", 2){

            public void run() {
                GeoAreaManager.this.enableFilter(!GeoAreaManager.this.initShowFilter);
                GeoAreaManager.this.actionShowFilter.setChecked(GeoAreaManager.this.initShowFilter);
            }
        };
        this.actionShowFilter.setChecked(this.initShowFilter);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.osm.commands.showFilter");
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
        this.actionRefresh = new RefreshAction(){

            public void run() {
                GeoAreaManager.this.refresh();
            }
        };
        this.actionNew = new Action("New...", SharedIcons.ADD_OBJECT){

            public void run() {
                GeoAreaManager.this.createArea();
            }
        };
        this.actionEdit = new Action("&Edit...", SharedIcons.EDIT){

            public void run() {
                GeoAreaManager.this.editArea();
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                GeoAreaManager.this.deleteAreas();
            }
        };
        this.actionImport = new Action("&Import...", Activator.getImageDescriptor("icons/import.gif")){

            public void run() {
                GeoAreaManager.this.importAreas();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionImport);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNew);
        manager.add((IAction)this.actionImport);
        manager.add((IAction)this.actionEdit);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                GeoAreaManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionImport);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
    }

    private void createArea() {
        GeoAreaEditDialog dlg = new GeoAreaEditDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            this.updateArea(dlg.getArea());
        }
    }

    private void editArea() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        GeoAreaEditDialog dlg = new GeoAreaEditDialog(this.getSite().getShell(), (GeoArea)selection.getFirstElement());
        if (dlg.open() == 0) {
            this.updateArea(dlg.getArea());
        }
    }

    private void updateArea(final GeoArea area) {
        new ConsoleJob("Modify geographical area", (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final int id = GeoAreaManager.this.session.modifyGeoArea(area);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeoArea newArea = (this).GeoAreaManager.this.areas.get(id);
                        if (newArea == null) {
                            newArea = new GeoArea(area);
                            (this).GeoAreaManager.this.areas.put(id, newArea);
                        }
                        (this).GeoAreaManager.this.viewer.refresh();
                        (this).GeoAreaManager.this.viewer.setSelection((ISelection)new StructuredSelection((Object)newArea));
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot modify object category";
            }
        }.start();
    }

    private void deleteAreas() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (!MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Delete Geographical Areas", (String)"Selected geographical areas will be deleted. Are you sure?")) {
            return;
        }
        final int[] idList = new int[selection.size()];
        int index = 0;
        for (Object o : selection.toList()) {
            idList[index++] = ((GeoArea)o).getId();
        }
        new ConsoleJob("Delete geographical areas", (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                monitor.beginTask("Delete geographical areas", idList.length);
                int[] nArray = idList;
                int n = idList.length;
                int n2 = 0;
                while (n2 < n) {
                    block4: {
                        final int id = nArray[n2];
                        try {
                            GeoAreaManager.this.session.deleteGeoArea(id, false);
                        }
                        catch (NXCException e) {
                            if (e.getErrorCode() != 141) {
                                throw e;
                            }
                            final boolean[] retry = new boolean[1];
                            this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    GeoArea a = (this).GeoAreaManager.this.areas.get(id);
                                    retry[0] = MessageDialogHelper.openQuestion((Shell)GeoAreaManager.this.getSite().getShell(), (String)"Confirm Delete", (String)String.format("Geographical area \"%s\" is in use. Are you sure you want to delete it?", a != null ? a.getName() : "[" + id + "]"));
                                }
                            });
                            if (!retry[0]) break block4;
                            GeoAreaManager.this.session.deleteGeoArea(id, true);
                        }
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                return "Cannot delete geographical area";
            }
        }.start();
    }

    private void refresh() {
        new ConsoleJob("Read configured geographical areas", (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List serverAreaList = GeoAreaManager.this.session.getGeoAreas();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).GeoAreaManager.this.areas.clear();
                        for (GeoArea a : serverAreaList) {
                            (this).GeoAreaManager.this.areas.put(a.getId(), a);
                        }
                        (this).GeoAreaManager.this.viewer.setInput((this).GeoAreaManager.this.areas.values());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get configured geographical areas";
            }
        }.start();
    }

    private void updateAreaDetails(GeoArea area) {
        if (area != null) {
            this.coordinateListViewer.setInput((Object)area.getBorder());
        } else {
            this.coordinateListViewer.setInput((Object)new Object[0]);
        }
        this.mapViewer.setArea(area);
    }

    private void importAreas() {
        FileDialog dlg = new FileDialog(this.getSite().getShell(), 4096);
        dlg.setFilterExtensions(new String[]{"*.kml", "*.*"});
        dlg.setFilterNames(new String[]{"KML files", "All files"});
        String fileName = dlg.open();
        if (fileName == null) {
            return;
        }
        final File file = new File(fileName);
        new ConsoleJob("Import areas from file", (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Map importedAreas = KMLParser.importPolygons((File)file);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        GeoAreaManager.this.validateImportedAreas(importedAreas);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot read import file";
            }
        }.start();
    }

    private void validateImportedAreas(final Map<String, List<GeoLocation>> importedAreas) {
        HashSet<String> skipSet = new HashSet<String>();
        final ArrayList<GeoArea> replaceList = new ArrayList<GeoArea>();
        for (String n : importedAreas.keySet()) {
            for (GeoArea a : this.areas.values()) {
                if (!a.getName().equalsIgnoreCase(n)) continue;
                if (MessageDialogHelper.openQuestion((Shell)this.getSite().getShell(), (String)"Override Geographical Area", (String)String.format("Geographical area with name \"%s\" already exist. Do you want to override it's content?", a.getName()))) {
                    replaceList.add(new GeoArea(a.getId(), a.getName(), a.getComments(), importedAreas.get(n)));
                }
                skipSet.add(n);
            }
        }
        for (String n : skipSet) {
            importedAreas.remove(n);
        }
        new ConsoleJob("Import geographical area", (IWorkbenchPart)this, "org.netxms.ui.eclipse.osm", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                for (GeoArea geoArea : replaceList) {
                    GeoAreaManager.this.session.modifyGeoArea(geoArea);
                }
                for (Map.Entry entry : importedAreas.entrySet()) {
                    GeoArea a = new GeoArea(0, (String)entry.getKey(), "Imported from KML", (List)entry.getValue());
                    GeoAreaManager.this.session.modifyGeoArea(a);
                }
            }

            protected String getErrorMessage() {
                return "Cannot update geographical area on server";
            }
        }.start();
    }
}

