/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Alarm;
import org.netxms.client.events.AlarmComment;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.EditCommentDialog;
import org.netxms.ui.eclipse.alarmviewer.widgets.AlarmCommentsEditor;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.Section;

public class AlarmComments
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmComments";
    private static final String[] stateImage = new String[]{"icons/outstanding.png", "icons/acknowledged.png", "icons/terminated.png"};
    private static final String[] stateText;
    private NXCSession session = ConsoleSharedData.getSession();
    private long alarmId;
    private ImageCache imageCache;
    private WorkbenchLabelProvider wbLabelProvider;
    private Composite content;
    private CLabel alarmSeverity;
    private CLabel alarmState;
    private CLabel alarmSource;
    private Label alarmText;
    private ScrolledComposite editorsScroller;
    private Composite editorsArea;
    private ImageHyperlink linkAddComment;
    private Map<Long, AlarmCommentsEditor> editors = new HashMap<Long, AlarmCommentsEditor>();
    private Action actionRefresh;

    static {
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.AlarmListLabelProvider_AlarmState_Outstanding;
        Messages.get();
        stringArray[1] = Messages.AlarmListLabelProvider_AlarmState_Acknowledged;
        Messages.get();
        stringArray[2] = Messages.AlarmListLabelProvider_AlarmState_Terminated;
        stateText = stringArray;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.wbLabelProvider = new WorkbenchLabelProvider();
        try {
            this.alarmId = Long.parseLong(site.getSecondaryId());
        }
        catch (NumberFormatException e) {
            Messages.get();
            throw new PartInitException(Messages.AlarmComments_InternalError, (Throwable)e);
        }
        this.setPartName(String.valueOf(this.getPartName()) + " [" + Long.toString(this.alarmId) + "]");
    }

    public void createPartControl(Composite parent) {
        this.imageCache = new ImageCache();
        this.content = parent;
        this.content.setLayout((Layout)new GridLayout());
        this.createAlarmDetailsSection();
        this.createEditorsSection();
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AlarmComments.this.refresh();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createAlarmDetailsSection() {
        Messages.get();
        Section section = new Section(this.content, Messages.AlarmComments_Details, true);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite clientArea = section.getClient();
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        clientArea.setLayout((Layout)layout);
        this.alarmSeverity = new CLabel(clientArea, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmSeverity.setLayoutData((Object)gd);
        this.alarmState = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.alarmState.setLayoutData((Object)gd);
        this.alarmSource = new CLabel(clientArea, 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmSource.setLayoutData((Object)gd);
        this.alarmText = new Label(clientArea, 64);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.alarmText.setLayoutData((Object)gd);
    }

    private void createEditorsSection() {
        Messages.get();
        Section section = new Section(this.content, Messages.AlarmComments_Comments, false);
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        this.editorsScroller = new ScrolledComposite(section.getClient(), 512);
        this.editorsScroller.setBackground(section.getClient().getBackground());
        this.editorsScroller.setExpandHorizontal(true);
        this.editorsScroller.setExpandVertical(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.editorsScroller, (int)512, (int)20);
        this.editorsScroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AlarmComments.this.editorsArea.layout(true, true);
                AlarmComments.this.editorsScroller.setMinSize(AlarmComments.this.editorsArea.computeSize(AlarmComments.this.editorsScroller.getClientArea().width, -1));
            }
        });
        this.editorsArea = new Composite((Composite)this.editorsScroller, 0);
        this.editorsArea.setBackground(section.getClient().getBackground());
        GridLayout layout = new GridLayout();
        this.editorsArea.setLayout((Layout)layout);
        this.editorsScroller.setContent((Control)this.editorsArea);
        this.linkAddComment = new ImageHyperlink(this.editorsArea, 0);
        this.linkAddComment.setImage(this.imageCache.add(Activator.getImageDescriptor("icons/new_comment.png")));
        Messages.get();
        this.linkAddComment.setText(Messages.AlarmComments_AddCommentLink);
        this.linkAddComment.setBackground(this.editorsArea.getBackground());
        this.linkAddComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmComments.this.addComment();
            }
        });
    }

    public void setFocus() {
        this.editorsArea.setFocus();
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_GetComments, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Alarm alarm = AlarmComments.this.session.getAlarm(AlarmComments.this.alarmId);
                final List comments = AlarmComments.this.session.getAlarmComments(AlarmComments.this.alarmId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmComments.this.updateAlarmDetails(alarm);
                        for (AlarmCommentsEditor e : (this).AlarmComments.this.editors.values()) {
                            e.dispose();
                        }
                        for (AlarmComment c : comments) {
                            (this).AlarmComments.this.editors.put(c.getId(), AlarmComments.this.createEditor(c));
                        }
                        AlarmComments.this.updateLayout();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_GetError;
            }
        }.start();
    }

    private void updateLayout() {
        this.content.layout(true, true);
        this.editorsArea.layout(true, true);
        this.editorsScroller.setMinSize(this.editorsArea.computeSize(this.editorsScroller.getClientArea().width, -1));
    }

    private AlarmCommentsEditor createEditor(final AlarmComment note) {
        HyperlinkAdapter editAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmComments.this.editComment(note.getId(), note.getText());
            }
        };
        HyperlinkAdapter deleteAction = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                AlarmComments.this.deleteComment(note.getId());
            }
        };
        AlarmCommentsEditor e = new AlarmCommentsEditor(this.editorsArea, this.imageCache, note, editAction, deleteAction);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        e.setLayoutData(gd);
        e.moveBelow((Control)this.linkAddComment);
        return e;
    }

    private void addComment() {
        this.editComment(0L, "");
    }

    private void editComment(final long noteId, String noteText) {
        final EditCommentDialog dlg = new EditCommentDialog(this.getSite().getShell(), noteId, noteText);
        if (dlg.open() != 0) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_AddCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmComments.this.session.updateAlarmComment(AlarmComments.this.alarmId, noteId, dlg.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmComments.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_AddError;
            }
        }.start();
    }

    private void deleteComment(final long noteId) {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.AlarmComments_Confirmation, (String)Messages.AlarmComments_AckToDeleteComment)) {
            return;
        }
        Messages.get();
        new ConsoleJob(Messages.AlarmComments_DeleteCommentJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.alarmviewer", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmComments.this.session.deleteAlarmComment(AlarmComments.this.alarmId, noteId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AlarmComments.this.refresh();
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmComments_ErrorDeleteAlarmComment;
            }
        }.start();
    }

    private void updateAlarmDetails(Alarm alarm) {
        this.alarmSeverity.setImage(StatusDisplayInfo.getStatusImage((Severity)alarm.getCurrentSeverity()));
        this.alarmSeverity.setText(StatusDisplayInfo.getStatusText((Severity)alarm.getCurrentSeverity()));
        this.alarmState.setImage(this.imageCache.add(Activator.getImageDescriptor(stateImage[alarm.getState()])));
        this.alarmState.setText(stateText[alarm.getState()]);
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        this.alarmSource.setImage(object != null ? this.wbLabelProvider.getImage((Object)object) : SharedIcons.IMG_UNKNOWN_OBJECT);
        this.alarmSource.setText(object != null ? object.getObjectName() : "[" + Long.toString(alarm.getSourceObjectId()) + "]");
        this.alarmText.setText(alarm.getMessage());
    }

    public void dispose() {
        this.imageCache.dispose();
        this.wbLabelProvider.dispose();
        super.dispose();
    }
}

