/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.views;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.dashboard.Activator;
import org.netxms.ui.eclipse.dashboard.ElementCreationHandler;
import org.netxms.ui.eclipse.dashboard.ElementCreationMenuManager;
import org.netxms.ui.eclipse.dashboard.Messages;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.LineChartElement;
import org.netxms.ui.eclipse.dashboard.widgets.internal.DashboardModifyListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.IntermediateSelectionProvider;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DashboardView
extends ViewPart
implements ISaveablePart {
    public static final String ID = "org.netxms.ui.eclipse.dashboard.views.DashboardView";
    private NXCSession session;
    private SessionListener clientListener;
    private Dashboard dashboard;
    private boolean readOnly = true;
    private IntermediateSelectionProvider selectionProvider;
    private boolean fullScreenDisplay = false;
    private Shell fullScreenDisplayShell;
    private Composite parentComposite;
    private DashboardControl dbc;
    private DashboardModifyListener dbcModifyListener;
    private Action actionRefresh;
    private Action actionEditMode;
    private Action actionAddColumn;
    private Action actionRemoveColumn;
    private Action actionSave;
    private Action actionExportValues;
    private Action actionFullScreenDisplay;
    private Action actionSaveAsImage;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = ConsoleSharedData.getSession();
        this.dashboard = (Dashboard)this.session.findObjectById(Long.parseLong(site.getSecondaryId()), Dashboard.class);
        if (this.dashboard == null) {
            Messages.get();
            throw new PartInitException(Messages.DashboardView_InitError);
        }
        Messages.get();
        this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
    }

    public void createPartControl(Composite parent) {
        this.selectionProvider = new IntermediateSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        this.parentComposite = parent;
        this.clientListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4 && DashboardView.this.dashboard.getObjectId() == n.getSubCode()) {
                    DashboardView.this.parentComposite.getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            DashboardView.this.rebuildDashboard(true);
                        }
                    });
                }
            }
        };
        this.dbc = new DashboardControl(parent, 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
        this.activateContext();
        this.createActions();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.DashboardView_GetEffectiveRights, (IWorkbenchPart)this, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                DashboardView.this.readOnly = (DashboardView.this.dashboard.getEffectiveRights() & 2) == 0;
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).DashboardView.this.readOnly) {
                            (this).DashboardView.this.dbcModifyListener = new DashboardModifyListener(){

                                @Override
                                public void save() {
                                    ((this).this).DashboardView.this.actionSave.setEnabled(false);
                                    DashboardView.this.firePropertyChange(257);
                                }

                                @Override
                                public void modify() {
                                    ((this).this).DashboardView.this.actionSave.setEnabled(true);
                                    DashboardView.this.firePropertyChange(257);
                                }
                            };
                            (this).DashboardView.this.dbc.setModifyListener((this).DashboardView.this.dbcModifyListener);
                        }
                        DashboardView.this.contributeToActionBars();
                        DashboardView.this.getViewSite().getActionBars().updateActionBars();
                        (this).DashboardView.this.session.addListener((this).DashboardView.this.clientListener);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardView_GetEffectiveRightsError;
            }
        };
        job.start();
        this.addPartPropertyListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("FullScreen")) {
                    boolean enable = Boolean.parseBoolean(event.getNewValue().toString());
                    DashboardView.this.actionFullScreenDisplay.setChecked(enable);
                    DashboardView.this.enableFullScreenDisplay(enable);
                }
            }
        });
    }

    public void dispose() {
        if (this.fullScreenDisplayShell != null && !this.fullScreenDisplayShell.isDisposed()) {
            this.fullScreenDisplayShell.close();
            this.fullScreenDisplayShell.dispose();
        }
        if (this.session != null && this.clientListener != null) {
            this.session.removeListener(this.clientListener);
        }
        super.dispose();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.dashboard.context.DashboardView");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                if (DashboardView.this.dbc.isModified()) {
                    Shell shell = DashboardView.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DashboardView_Refresh, (String)Messages.DashboardView_Confirmation)) {
                        return;
                    }
                }
                DashboardView.this.rebuildDashboard(true);
            }
        };
        Messages.get();
        this.actionSave = new Action(Messages.DashboardView_Save, SharedIcons.SAVE){

            public void run() {
                DashboardView.this.dbc.saveDashboard((IViewPart)DashboardView.this);
            }
        };
        this.actionSave.setEnabled(false);
        Messages.get();
        this.actionExportValues = new Action(Messages.DashboardView_ExportLineChartValues, Activator.getImageDescriptor("icons/export-data.png")){

            public void run() {
                DashboardView.this.exportLineChartValues();
            }
        };
        this.actionExportValues.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.export_line_chart_values");
        handlerService.activateHandler(this.actionExportValues.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionExportValues));
        this.actionSaveAsImage = new Action("Save as &image", SharedIcons.SAVE_AS_IMAGE){

            public void run() {
                DashboardView.this.saveAsImage();
            }
        };
        this.actionSaveAsImage.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.save_as_image");
        handlerService.activateHandler(this.actionSaveAsImage.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSaveAsImage));
        Messages.get();
        this.actionEditMode = new Action(Messages.DashboardView_EditMode, 2){

            public void run() {
                DashboardView.this.dbc.setEditMode(!DashboardView.this.dbc.isEditMode());
                DashboardView.this.actionEditMode.setChecked(DashboardView.this.dbc.isEditMode());
                if (!DashboardView.this.dbc.isEditMode()) {
                    DashboardView.this.rebuildDashboard(false);
                }
            }
        };
        this.actionEditMode.setImageDescriptor(SharedIcons.EDIT);
        this.actionEditMode.setChecked(this.dbc.isEditMode());
        this.actionAddColumn = new Action("Add &column", Activator.getImageDescriptor("icons/add-column.png")){

            public void run() {
                DashboardView.this.dbc.addColumn();
                if (DashboardView.this.dbc.getColumnCount() == 128) {
                    DashboardView.this.actionAddColumn.setEnabled(false);
                }
                DashboardView.this.actionRemoveColumn.setEnabled(true);
            }
        };
        this.actionAddColumn.setEnabled(this.dashboard.getNumColumns() < 128);
        this.actionRemoveColumn = new Action("&Remove column", Activator.getImageDescriptor("icons/remove-column.png")){

            public void run() {
                DashboardView.this.dbc.removeColumn();
                if (DashboardView.this.dbc.getColumnCount() == DashboardView.this.dbc.getMinimalColumnCount()) {
                    DashboardView.this.actionRemoveColumn.setEnabled(false);
                }
                DashboardView.this.actionAddColumn.setEnabled(true);
            }
        };
        this.actionRemoveColumn.setEnabled(this.dashboard.getNumColumns() > this.dbc.getMinimalColumnCount());
        this.actionFullScreenDisplay = new Action("&Full screen display", 2){

            public void run() {
                DashboardView.this.enableFullScreenDisplay(DashboardView.this.actionFullScreenDisplay.isChecked());
            }
        };
        this.actionFullScreenDisplay.setImageDescriptor(Activator.getImageDescriptor("icons/full-screen.png"));
        this.actionFullScreenDisplay.setActionDefinitionId("org.netxms.ui.eclipse.dashboard.commands.full_screen");
        handlerService.activateHandler(this.actionFullScreenDisplay.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionFullScreenDisplay));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
            manager.add((IContributionItem)new Separator());
            manager.add((IContributionItem)new ElementCreationMenuManager("&Add", new ElementCreationHandler(){

                @Override
                public void elementCreated(DashboardElement element) {
                    DashboardView.this.dbc.addElement(element);
                }
            }));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionAddColumn);
            manager.add((IAction)this.actionRemoveColumn);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionExportValues);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFullScreenDisplay);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        if (!this.readOnly) {
            manager.add((IAction)this.actionEditMode);
            manager.add((IAction)this.actionSave);
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionAddColumn);
            manager.add((IAction)this.actionRemoveColumn);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionExportValues);
        manager.add((IAction)this.actionSaveAsImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionFullScreenDisplay);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    public void setFocus() {
        if (!this.dbc.isDisposed()) {
            this.dbc.setFocus();
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.dbc.saveDashboard((IViewPart)this);
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.dbc.isModified() && !this.readOnly;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.dbc.isModified() && !this.readOnly;
    }

    private void rebuildDashboard(boolean reload) {
        if (this.dashboard == null) {
            return;
        }
        if (this.dbc != null) {
            this.dbc.dispose();
        }
        if (reload) {
            this.dashboard = (Dashboard)ConsoleSharedData.getSession().findObjectById(this.dashboard.getObjectId(), Dashboard.class);
            if (this.dashboard != null) {
                this.dbc = new DashboardControl((Composite)(this.fullScreenDisplay ? this.fullScreenDisplayShell : this.parentComposite), 0, this.dashboard, (IViewPart)this, this.selectionProvider, false);
                this.dbc.getParent().layout(true, true);
                Messages.get();
                this.setPartName(String.valueOf(Messages.DashboardView_PartNamePrefix) + this.dashboard.getObjectName());
                if (!this.readOnly) {
                    this.dbc.setModifyListener(this.dbcModifyListener);
                }
            } else {
                this.dbc = null;
            }
        } else {
            this.dbc = new DashboardControl((Composite)(this.fullScreenDisplay ? this.fullScreenDisplayShell : this.parentComposite), 0, this.dbc);
            this.dbc.getParent().layout(true, true);
            if (!this.readOnly) {
                this.dbc.setModifyListener(this.dbcModifyListener);
            }
        }
        this.actionSave.setEnabled(this.dbc != null ? this.dbc.isModified() : false);
        this.actionAddColumn.setEnabled(this.dbc.getColumnCount() < 128);
        this.actionRemoveColumn.setEnabled(this.dbc.getColumnCount() > this.dbc.getMinimalColumnCount());
        this.firePropertyChange(257);
    }

    private void exportLineChartValues() {
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        fd.setFileName(String.valueOf(this.dashboard.getObjectName()) + ".csv");
        final String fileName = fd.open();
        if (fileName == null) {
            return;
        }
        final ArrayList<LineChartElement.DataCacheElement> data = new ArrayList<LineChartElement.DataCacheElement>();
        for (ElementWidget w : this.dbc.getElementWidgets()) {
            if (!(w instanceof LineChartElement)) continue;
            for (LineChartElement.DataCacheElement d : ((LineChartElement)w).getDataCache()) {
                data.add(d);
            }
        }
        final DateFormat dfDate = RegionalSettings.getDateFormat();
        final DateFormat dfTime = RegionalSettings.getTimeFormat();
        final DateFormat dfDateTime = RegionalSettings.getDateTimeFormat();
        Messages.get();
        new ConsoleJob(Messages.DashboardView_ExportLineChartData, (IWorkbenchPart)this, "org.netxms.ui.eclipse.dashboard", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                boolean doInterpolation = DashboardView.this.session.getPublicServerVariableAsBoolean("Client.DashboardDataExport.EnableInterpolation");
                ArrayList<Date> combinedTimeSeries = new ArrayList<Date>();
                for (LineChartElement.DataCacheElement d : data) {
                    DciDataRow[] dciDataRowArray = d.data.getValues();
                    int n = dciDataRowArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DciDataRow r = dciDataRowArray[n2];
                        int i = 0;
                        while (i < combinedTimeSeries.size()) {
                            if (((Date)combinedTimeSeries.get(i)).getTime() == r.getTimestamp().getTime()) break;
                            if (((Date)combinedTimeSeries.get(i)).getTime() < r.getTimestamp().getTime()) {
                                combinedTimeSeries.add(i, r.getTimestamp());
                                break;
                            }
                            ++i;
                        }
                        if (i == combinedTimeSeries.size()) {
                            combinedTimeSeries.add(r.getTimestamp());
                        }
                        ++n2;
                    }
                }
                ArrayList<Double[]> combinedData = new ArrayList<Double[]>(data.size());
                for (LineChartElement.DataCacheElement d : data) {
                    Double[] ySeries = new Double[combinedTimeSeries.size()];
                    int combinedIndex = 0;
                    double lastValue = 0.0;
                    long lastTimestamp = 0L;
                    DciDataRow[] values = d.data.getValues();
                    int i = 0;
                    while (i < values.length) {
                        Date currentTimestamp = values[i].getTimestamp();
                        double currentValue = values[i].getValueAsDouble();
                        long currentCombinedTimestamp = ((Date)combinedTimeSeries.get(combinedIndex)).getTime();
                        while (currentCombinedTimestamp > currentTimestamp.getTime()) {
                            ySeries[combinedIndex] = lastTimestamp != 0L && doInterpolation ? Double.valueOf(lastValue + (currentValue - lastValue) * ((double)(lastTimestamp - currentCombinedTimestamp) / (double)(lastTimestamp - currentTimestamp.getTime()))) : null;
                            currentCombinedTimestamp = ((Date)combinedTimeSeries.get(++combinedIndex)).getTime();
                        }
                        ySeries[combinedIndex++] = currentValue;
                        lastTimestamp = currentTimestamp.getTime();
                        lastValue = currentValue;
                        ++i;
                    }
                    combinedData.add(ySeries);
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));){
                    writer.write("# " + DashboardView.this.dashboard.getObjectName() + " " + dfDateTime.format(new Date()));
                    writer.newLine();
                    writer.write("DATE,TIME");
                    for (LineChartElement.DataCacheElement d : data) {
                        writer.write(44);
                        writer.write(d.name);
                    }
                    writer.newLine();
                    int i = combinedTimeSeries.size() - 1;
                    while (i >= 0) {
                        Date d = (Date)combinedTimeSeries.get(i);
                        writer.write(dfDate.format(d));
                        writer.write(44);
                        writer.write(dfTime.format(d));
                        for (Double[] values : combinedData) {
                            writer.write(44);
                            if (values[i] == null) continue;
                            double v = values[i];
                            if (Math.abs(v) > 0.001) {
                                writer.write(String.format("%.3f", v));
                                continue;
                            }
                            writer.write(Double.toString(v));
                        }
                        writer.newLine();
                        --i;
                    }
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DashboardView_8;
            }
        }.start();
    }

    private void enableFullScreenDisplay(boolean enable) {
        if (enable) {
            if (this.fullScreenDisplayShell == null) {
                this.fullScreenDisplayShell = new Shell(Display.getCurrent(), 1264);
                this.fullScreenDisplayShell.setLayout((Layout)new FillLayout());
                this.fullScreenDisplayShell.open();
                this.fullScreenDisplayShell.setFullScreen(true);
                this.fullScreenDisplayShell.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        if (e.keyCode == 0x1000014 && (e.stateMask & 0x410000) != 0) {
                            DashboardView.this.actionFullScreenDisplay.setChecked(false);
                            DashboardView.this.enableFullScreenDisplay(false);
                        }
                    }
                });
            }
        } else if (this.fullScreenDisplayShell != null) {
            if (!this.fullScreenDisplayShell.isDisposed()) {
                this.fullScreenDisplayShell.close();
                this.fullScreenDisplayShell.dispose();
            }
            this.fullScreenDisplayShell = null;
        }
        this.fullScreenDisplay = enable;
        this.rebuildDashboard(false);
        if (!enable) {
            this.parentComposite.setFocus();
        }
    }

    public void saveAsImage() {
        Rectangle rect = this.dbc.getClientArea();
        Image image = new Image((Device)this.dbc.getDisplay(), rect.width, rect.height);
        GC gc = new GC((Drawable)image);
        this.dbc.print(gc);
        gc.dispose();
        FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
        fd.setText("Save dashboard as image");
        String[] filterExtensions = new String[]{"*.*"};
        fd.setFilterExtensions(filterExtensions);
        String[] filterNames = new String[]{".png"};
        fd.setFilterNames(filterNames);
        String dateTime = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        fd.setFileName(String.valueOf(this.dashboard.getObjectName()) + "_" + dateTime + ".png");
        String selected = fd.open();
        if (selected == null) {
            return;
        }
        ImageLoader saver = new ImageLoader();
        saver.data = new ImageData[]{image.getImageData()};
        saver.save(selected, 5);
        image.dispose();
    }
}

