/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.propertypages;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.objects.GenericObject;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.DataCollectionObjectEditor;
import org.netxms.nxmc.modules.datacollection.propertypages.AbstractDCIPropertyPage;
import org.netxms.nxmc.modules.objects.widgets.ObjectSelector;
import org.netxms.nxmc.tools.WidgetHelper;
import org.xnap.commons.i18n.I18n;

public class OtherOptions
extends AbstractDCIPropertyPage {
    private static final I18n i18n = LocalizationHelper.getI18n(OtherOptions.class);
    private DataCollectionItem dci;
    private Button checkShowOnTooltip;
    private Button checkShowInOverview;
    private Button checkCalculateStatus;
    private Button checkHideOnLastValues;
    private Combo useMultipliers;
    private ObjectSelector relatedObject;

    public OtherOptions(DataCollectionObjectEditor editor) {
        super(i18n.tr("Other Options"), editor);
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = (Composite)super.createContents(parent);
        this.dci = this.editor.getObjectAsItem();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkShowOnTooltip = new Button(dialogArea, 32);
        this.checkShowOnTooltip.setText(i18n.tr("&Show last value in object tooltips"));
        this.checkShowOnTooltip.setSelection(this.dci.isShowOnObjectTooltip());
        this.checkShowInOverview = new Button(dialogArea, 32);
        this.checkShowInOverview.setText(i18n.tr("Show last value in object overview"));
        this.checkShowInOverview.setSelection(this.dci.isShowInObjectOverview());
        this.checkCalculateStatus = new Button(dialogArea, 32);
        this.checkCalculateStatus.setText(i18n.tr("Use this DCI for node status calculation"));
        this.checkCalculateStatus.setSelection(this.dci.isUsedForNodeStatusCalculation());
        this.checkHideOnLastValues = new Button(dialogArea, 32);
        this.checkHideOnLastValues.setText("Hide value on \"Last Values\" page");
        this.checkHideOnLastValues.setSelection(this.dci.isHideOnLastValuesView());
        this.useMultipliers = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Use multipliers", (Object)new GridData());
        this.useMultipliers.add("Default");
        this.useMultipliers.add("Yes");
        this.useMultipliers.add("No");
        this.useMultipliers.select(this.dci.getMultipliersSelection());
        this.relatedObject = new ObjectSelector(dialogArea, 0, true);
        this.relatedObject.setLabel("Related object");
        this.relatedObject.setObjectClass(GenericObject.class);
        this.relatedObject.setObjectId(this.dci.getRelatedObject());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.relatedObject.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected boolean applyChanges(boolean isApply) {
        this.dci.setShowOnObjectTooltip(this.checkShowOnTooltip.getSelection());
        this.dci.setShowInObjectOverview(this.checkShowInOverview.getSelection());
        this.dci.setUsedForNodeStatusCalculation(this.checkCalculateStatus.getSelection());
        this.dci.setHideOnLastValuesView(this.checkHideOnLastValues.getSelection());
        this.dci.setMultiplierSelection(this.useMultipliers.getSelectionIndex());
        this.dci.setRelatedObject(this.relatedObject.getObjectId());
        this.editor.modify();
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkShowOnTooltip.setSelection(false);
        this.checkShowInOverview.setSelection(false);
        this.checkCalculateStatus.setSelection(false);
        this.checkHideOnLastValues.setSelection(false);
        this.useMultipliers.select(0);
        this.relatedObject.setObjectId(0L);
    }
}

