/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.datacollection.views.helpers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;
import org.netxms.client.datacollection.DataCollectionItem;
import org.netxms.client.datacollection.DataCollectionObject;
import org.netxms.client.datacollection.DataCollectionTable;
import org.netxms.client.datacollection.TableThreshold;
import org.netxms.client.datacollection.Threshold;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Template;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.netxms.nxmc.modules.datacollection.widgets.helpers.DataCollectionDisplayInfo;
import org.netxms.nxmc.resources.ResourceManager;
import org.xnap.commons.i18n.I18n;

public class DciLabelProvider
implements ITableLabelProvider,
IColorProvider {
    private I18n i18n = LocalizationHelper.getI18n(DciLabelProvider.class);
    private static final Color FONT_COLOR = new Color((Device)Display.getDefault(), new RGB(126, 137, 185));
    private NXCSession session;
    private Image[] statusImages;
    private HashMap<DataOrigin, String> originTexts = new HashMap();
    private HashMap<Integer, String> statusTexts = new HashMap();

    public DciLabelProvider() {
        this.session = Registry.getSession();
        this.statusImages = new Image[3];
        this.statusImages[0] = ResourceManager.getImageDescriptor((String)"icons/dci/active.gif").createImage();
        this.statusImages[1] = ResourceManager.getImageDescriptor((String)"icons/dci/disabled.gif").createImage();
        this.statusImages[2] = ResourceManager.getImageDescriptor((String)"icons/dci/unsupported.gif").createImage();
        this.originTexts.put(DataOrigin.AGENT, this.i18n.tr("NetXMS Agent"));
        this.originTexts.put(DataOrigin.DEVICE_DRIVER, this.i18n.tr("Network Device Driver"));
        this.originTexts.put(DataOrigin.INTERNAL, this.i18n.tr("Internal"));
        this.originTexts.put(DataOrigin.MQTT, this.i18n.tr("MQTT"));
        this.originTexts.put(DataOrigin.PUSH, this.i18n.tr("Push"));
        this.originTexts.put(DataOrigin.SCRIPT, this.i18n.tr("Script"));
        this.originTexts.put(DataOrigin.SMCLP, this.i18n.tr("SM-CLP"));
        this.originTexts.put(DataOrigin.SNMP, this.i18n.tr("SNMP"));
        this.originTexts.put(DataOrigin.SSH, this.i18n.tr("SSH"));
        this.originTexts.put(DataOrigin.WEB_SERVICE, this.i18n.tr("Web Service"));
        this.originTexts.put(DataOrigin.WINPERF, this.i18n.tr("Windows Performance Counters"));
        this.statusTexts.put(0, this.i18n.tr("Active"));
        this.statusTexts.put(1, this.i18n.tr("Disabled"));
        this.statusTexts.put(2, this.i18n.tr("Not supported"));
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 0) {
            return null;
        }
        int status = ((DataCollectionObject)element).getStatus();
        return status >= 0 && status < this.statusImages.length ? this.statusImages[status] : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DataCollectionObject dci = (DataCollectionObject)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(dci.getId());
            }
            case 1: {
                return (String)this.originTexts.get(dci.getOrigin());
            }
            case 2: {
                return dci.getDescription();
            }
            case 3: {
                return dci.getName();
            }
            case 4: {
                if (dci instanceof DataCollectionItem) {
                    return DataCollectionDisplayInfo.getDataTypeName((DataType)((DataCollectionItem)dci).getDataType());
                }
                return this.i18n.tr("<< TABLE >>");
            }
            case 5: {
                if (dci.isUseAdvancedSchedule()) {
                    return this.i18n.tr("custom schedule");
                }
                if (dci.getPollingScheduleType() == 0) {
                    return this.i18n.tr("default");
                }
                return dci.getPollingInterval();
            }
            case 6: {
                if (dci.getRetentionType() == 2) {
                    return this.i18n.tr("none");
                }
                if (dci.getRetentionType() == 0) {
                    return this.i18n.tr("default");
                }
                try {
                    int days = Integer.parseInt(dci.getRetentionTime());
                    if (days <= 0) {
                        return this.i18n.tr("default");
                    }
                    return Integer.toString(days) + (days == 1 ? this.i18n.tr(" day") : this.i18n.tr(" days"));
                }
                catch (NumberFormatException e) {
                    return dci.getRetentionTime();
                }
            }
            case 7: {
                return (String)this.statusTexts.get(dci.getStatus());
            }
            case 8: {
                int i;
                List list;
                StringBuilder thresholds = new StringBuilder();
                if (dci instanceof DataCollectionItem) {
                    list = ((DataCollectionItem)dci).getThresholds();
                    for (i = 0; i < ((ArrayList)list).size(); ++i) {
                        Threshold tr = (Threshold)((ArrayList)list).get(i);
                        thresholds.append(tr.getTextualRepresentation());
                        if (i >= ((ArrayList)list).size() - 1) continue;
                        thresholds.append(", ");
                    }
                }
                if (dci instanceof DataCollectionTable) {
                    list = ((DataCollectionTable)dci).getThresholds();
                    for (i = 0; i < list.size(); ++i) {
                        thresholds.append(((TableThreshold)list.get(i)).getConditionAsText());
                        if (i + 1 == list.size()) continue;
                        thresholds.append(", ");
                    }
                }
                return thresholds.toString();
            }
            case 9: {
                if (dci.getTemplateId() == 0L) {
                    return null;
                }
                AbstractObject object = this.session.findObjectById(dci.getTemplateId());
                if (object == null) {
                    return this.i18n.tr("<unknown>");
                }
                if (!(object instanceof Template)) {
                    return object.getObjectName();
                }
                List parents = object.getParentChain(null);
                Collections.reverse(parents);
                StringBuilder sb = new StringBuilder();
                for (AbstractObject parent : parents) {
                    sb.append(parent.getObjectName());
                    sb.append("/");
                }
                sb.append(object.getObjectName());
                return sb.toString();
            }
            case 10: {
                if (dci.getRelatedObject() == 0L) {
                    return null;
                }
                AbstractObject obj = this.session.findObjectById(dci.getRelatedObject());
                if (obj == null) {
                    return "[" + dci.getRelatedObject() + "]";
                }
                return obj.getObjectName();
            }
            case 11: {
                if (dci instanceof DataCollectionItem) {
                    return ((DataCollectionItem)dci).isUsedForNodeStatusCalculation() ? "Yes" : "No";
                }
                return this.i18n.tr("No");
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
        for (int i = 0; i < this.statusImages.length; ++i) {
            this.statusImages[i].dispose();
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Color getForeground(Object element) {
        if (((DataCollectionObject)element).getTemplateId() != 0L) {
            return FONT_COLOR;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

