/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.nxmc.modules.networkmaps.propertypages.helpers;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.client.objects.AbstractObject;
import org.netxms.nxmc.Registry;
import org.netxms.nxmc.localization.LocalizationHelper;
import org.xnap.commons.i18n.I18n;

public class DciListLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private I18n i18n = LocalizationHelper.getI18n(DciListLabelProvider.class);
    private NXCSession session = Registry.getSession();
    private Map<Long, String> dciNameCache = new HashMap();
    private List<SingleDciConfig> elementList;

    public DciListLabelProvider(List<SingleDciConfig> elementList) {
        this.elementList = elementList;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        SingleDciConfig dci = (SingleDciConfig)element;
        switch (columnIndex) {
            case 0: {
                return Integer.toString(this.elementList.indexOf(dci) + 1);
            }
            case 1: {
                AbstractObject object = this.session.findObjectById(dci.getNodeId());
                return object != null ? object.getObjectName() : "[" + Long.toString(dci.getNodeId()) + "]";
            }
            case 2: {
                String name = (String)this.dciNameCache.get(dci.dciId);
                return name != null ? name : this.i18n.tr("Unresolved DCI name");
            }
            case 3: {
                return dci.name;
            }
        }
        return null;
    }

    public void resolveDciNames(Collection<SingleDciConfig> dciList) {
        new /* Unavailable Anonymous Inner Class!! */.runInForeground();
    }

    public void addCacheEntry(long nodeId, long dciId, String name) {
        this.dciNameCache.put(dciId, name);
    }
}

